%This function sets the values of dependent shape variables based on the independent shape variables.
function newX=enforce_shape_sym(X,N_member,opt)
switch N_member
    case 47 % if it is the 47-bar tranmission tower problem
        X(3:4:end)=-X(1:4:end);
        X(4:4:end)=X(2:4:end);
        newX=X;
    case 110 % 110-bar transmission tower
        X(3:4:56)=-X(1:4:56);
        X(4:4:56)=X(2:4:56);
        newX=X;
    case 224 % if it is the 224-bar pyramid problem
        X(5:48:150)=X(4:48:150);
        for k=0:3
           N=[2 3 4]+16*k;
           M=[6 5 4]+16*k;
           X(M*3-2)=-X(N*3-2);
           X(M*3-1)=X(N*3-1);
           N=[2:6]+16*k;
           M=[10:-1:6]+16*k;
           X(M*3-2)=-X(N*3-1);
           X(M*3-1)=-X(N*3-2);
           N=[2:9]+16*k;
           M=[10:1:17]+16*k;
           X(M*3-2)=-X(N*3-2);
           X(M*3-1)=-X(N*3-1);
           X(([2:17]+16*k)*3)=X((2+16*k)*3);
        end
        newX=X;
    case 277 % if it is the 277-bar bridge problem
        sym_NAP=[1:28;[      59   56	57	58	53	54	55	50	51	52	47	48	49	44	45	46	41	42	43	38	39	40	35	36	37	32	33	34	]];
        if opt.case==1
            X(8:6:end)=X(2*31);
            X(6:6:end)=.5*X(62);
        elseif opt.case==2
            X(6:6:end)=.5*X(8:6:end);
        end
        X(sym_NAP(2,:)*2)=X(sym_NAP(1,:)*2);
        X(sym_NAP(2,:)*2-1)=6000-X(sym_NAP(1,:)*2-1);
        newX=X;
    otherwise
        newX=X;
end
