function avail_sec=sections(problemNo)
% enter the available cross sections in here and allocate a section_no for that
% use a number between 1-99 for the list number if you use simplified specifications. enter section areas as a vertical vector
% If AISC-ASD specifications govern, section data should be provided as a two column matrix. The first column specifies the area of the cross sections and the second column specifies the corresponding radii of gyration. If two sections have equal area, only include the one with the larger radius of gyration.

switch problemNo
    case 7  % sections for simplified specifications 
       avail_sec=(.1:.1:5)';
    case 101  % use a number equal to or greater that 101 if AISC-ASD (9th edition) is employed. 
       avail_sec=[0.25	0.32	0.333	0.433	0.494	0.639	0.669	0.799	0.881	1.07	1.48	1.7	2.23	2.25	2.66	2.68	3.02	3.17	3.68	4.03	4.3	4.41	5.47	5.58	6.11	8.1	8.4	11.3	11.9	12.8	14.6	15.6	16.1	19.2	21.3
                  0.261	0.25	0.334	0.321	0.421	0.407	0.54	0.623	0.524	0.787	0.766	0.947	1.16	0.924	0.703	1.34	1.14	1.51	1.31	0.844	1.88	1.48	1.05	2.25	1.84	1.37	2.94	1.72	3.67	2.88	4.38	2.06	3.63	4.33	2.76]';
       avail_sec(:,1)=avail_sec(:,1)*.0254^2; % Convert to SI (areas)
       avail_sec(:,2)=avail_sec(:,2)*.0254; % Convert to SI (radii of gyration)
    case 102 % AISC-ASD sections for bridge design problem
       avail_sec=[3.54,4.16,4.41,4.71,4.99,5.57,5.62,6.48,6.49,7.61,7.65,7.69,8.79,8.84,8.85,9.71,10,10.3,11.2,11.5,11.8,12.6,13.2,13.3,14.1,14.4,14.7,15.6,15.8,17,17.6,17.9,19.1,20,21.8,22.6,23.2,24.1,25.6,25.9,26.5,28.2,29.1,29.4,31.2,32,32.9,35.3,38.8,39.9,42.7,44.7,46.7,50,51.8,55.8,56.8,61.8,62,67.7,68.5,74.1,75.6,81.9,83.3,89.6,91.4,98.8,101,109,117,125,134,147,162,178,196,215
                  0.785,0.753,0.81,0.773,0.844,0.822,0.874,0.847,1.33,1.36,1.51,1.08,1.52,1.37,1.49,1.94,1.53,1.54,1.55,1.98,1.93,1.89,1.94,2.01,1.91,2.54,1.96,2.48,2.56,2.51,2.57,2.45,2.43,2.59,3.04,2.6,2.58,2.48,2.46,2.63,3.7,3.68,3.71,2.65,2.63,3.73,2.68,3.74,3.76,3.73,3.98,3.95,4,3.97,4.02,3.99,4.05,4.02,4.07,4.04,4.1,3.34,4.13,3.38,4.17,3.42,4.2,3.47,4.24,4.27,4.31,4.34,4.38,4.43,4.49,4.55,4.62,4.69]';
end
    

   