% Please read the readme.pdf file before using this code. 
clear;
D=2; %planar or spatial truss
N_node=29; % number of nodes in the ground structure
N_member=110; % number of nodes in the ground structure
GSCP=[1	1	1	1	2	2	2	2	3	3	3	3	3	4	4	4	4	5	5	5	5	5	6	6	6	6	7	7	7	7	7	8	8	8	8	9	9	9	9	9	10	10	10	10	11	11	11	11	11	12	12	12	12	13	13	13	13	13	14	14	14	14	15	15	15	15	15	16	16	16	16	17	17	17	18	18	19	19	19	19	19	19	19	19	20	20	20	20	20	20	20	21	21	21	21	22	22	22	22	23	23	24	24	25	25	26	26	27	27	28
3	4	5	6	3	4	5	6	4	5	6	7	8	5	6	7	8	6	7	8	9	10	7	8	9	10	8	9	10	11	12	9	10	11	12	10	11	12	13	14	11	12	13	14	12	13	14	15	16	13	14	15	16	14	15	16	17	18	15	16	17	18	16	17	18	19	20	17	18	19	20	18	19	20	19	20	20	21	22	25	26	27	28	29	21	22	25	26	27	28	29	23	25	27	29	24	26	28	29	25	27	26	28	27	29	28	29	28	29	29
]'; % a matrix determining the connectivity plot in the ground structure (N_member rows, 2 columns)
%define grouped members in a matrix
sym_M=[2	1	4	3	11	10	13	12	20	19	22	21	29	28	31	30	38	37	40	39	47	46	49	48	56	55	58	57	65	64	67	66	74	73	79	78	81	80	83	82	84	92	93	94	95	100	101	104	105	109
5	6	7	8	14	15	16	17	23	24	25	26	32	33	34	35	41	42	43	44	50	51	52	53	59	60	61	62	68	69	70	71	75	76	85	86	87	88	89	90	91	96	97	98	99	102	103	106	107	110
]; % topologically grouped members. 
sym_A=sym_M; % members with similar sections (In most test problems in the literature, sym_M=sym_A)
DOF_constrained=[1:4]; % DOFs anchored by the supports
% Define external load(s) applied to the structure
Fext=zeros(3,D*N_node)';
Fext([ 47 48 ],1)=[6000 -14000];
Fext([ 45 46 ],2)=[6000 -14000];
Fext([45 46 47 48 ],3)=[6000 -14000 6000 -14000];

%Define Mechanical Properties
M_elasticity=3e7;  %modulus of elasticity
SigT_all=20e3; % tensile strength
SigC_all=15e3; % comprehessive strength
Density=0.3; % density of truss material
kappa=3.96; % The parameter in the elastic buckling equation ( sigma_c<=kappa*EI/l^2)
dis_all=1e12; % allowable displacement along each DOF. If there is no displacement, set dis_all=1e12 
%section_no=7; % The avilable section list for this problem. (see sections.m)
SF_buck=pi^2/kappa; 
Max_Kcond=1e14;

best_feas_design=[
-147.838665
0
147.838665
0
-61.79301011
92.50828567
61.79301011
92.50828567
-127.8417582
139.088529
127.8417582
139.088529
-24.5891957
183.3227675
24.5891957
183.3227675
-108.6526348
270.6268113
108.6526348
270.6268113
-88.02548051
381.346182
88.02548051
381.346182
-39.3854548
362.8465024
39.3854548
362.8465024
-81.70447737
412.9003998
81.70447737
412.9003998
-10.81280012
453.9078951
10.81280012
453.9078951
-78.57419007
500.1118418
78.57419007
500.1118418
-90
570
90
570
-150
600
150
600
-122.7644511
552.0319971
122.7644511
552.0319971
-85.10656528
599.7883781
85.10656528
599.7883781
0
582.2043175
0.5
0.860838548
2.6
1.252684428
0.860838548
0.5
1.252684428
2.6
0.223904084
0.1
0.468051981
0.1
0.5
0.468051981
0.1
0.5
0.1
0.107189423
0.1
0.115155176
2.6
0.654691078
0.115155176
0.1
0.654691078
2.6
0.178867506
0.5
0.387225084
1.251636391
1.153220475
0.387225084
0.5
1.153220475
1.251636391
0.173848089
1.6
0.916552751
1.2
0.929605484
0.916552751
1.6
0.929605484
1.2
0.118942245
0.1
0.241261947
1.6
0.738793426
0.241261947
0.1
0.738793426
1.6
0.158465286
0.2
0.591316241
0.666558709
1.1
0.591316241
0.2
1.1
0.666558709
0.159422238
0.6
0.33860401
1.4
0.955260361
0.33860401
0.6
0.955260361
1.4
0.240697373
1
0.8
0.8
1
1.004593024
0.4
1.500342769
1.1
0.952973866
0.67525923
1.226163217
1.1
1.500342769
0.4
0.952973866
1.1
1.226163217
0.67525923
1.1
0.327186844
0.2
0.2
0.2
0.327186844
0.2
0.2
0.2
1.1
0.7
1.1
0.7
0.166191534
0.105483512
0.166191534
0.105483512
0.259959004
0.7
0.7
1
0
1
0
0
1
0
1
0
1
0
1
1
0
1
1
1
0
1
0
1
0
0
1
0
1
0
1
0
0
0
0
1
0
0
0
1
0
1
0
0
1
0
1
0
1
0
1
0
0
1
0
1
0
1
0
0
1
0
1
1
0
0
1
0
1
0
0
1
0
1
0
1
1
1
1
0
1
0
1
0
0
0
1
0
1
0
1
0
0
1
0
1
1
1
0
1
1
1
1
1
1
1
0
0
0
0
0
1
1
1314.046814

];

 
        
X=best_feas_design(1:D*N_node)'; % Shape parameters
A=best_feas_design(D*N_node+(1:N_member))'; % Size Parameters
M=best_feas_design(D*N_node+N_member+(1:N_member))'; % Topology Parameters
NAP=find_NAP(GSCP,M); % Active nodes
[Length_M,Vol,displ_ratio,buck_ratio,   stress_ratio,f_int_ext,displacement,f_int_unit]=FE_solve_2D3D_simp(NAP,X,DOF_constrained,A,   M,GSCP,Fext,M_elasticity,SigT_all,SigC_all,dis_all,Max_Kcond,D); 
buck_ratio= sqrt(SF_buck*buck_ratio);


clc
disp(['Maximum constraint ratio (must be equal to or less than one for a feasible design):'])
disp(['Max stress ratio: ' num2str(max(stress_ratio))]) 
disp(['Max buckling ratio: ' num2str(max(buck_ratio))])
disp(['Max displacement ratio: ' num2str(max(displ_ratio))])
disp(['Structural weight: ' num2str(Vol*Density)])
plot_truss(GSCP,X,NAP,M,A,D);


