% Please read the readme.pdf file before using this code. 
clear;
D=3; %planar or spatial truss
N_node=65; % number of nodes in the ground structure
N_member=224; % number of nodes in the ground structure
GSCP=[49	34	35	50	34	35	36	50	35	36	37	51	36	37	38	52	37	38	39	53	38	39	40	54	39	40	41	55	40	41	42	56	41	42	43	57	42	43	44	58	43	44	45	59	44	45	46	60	45	46	47	61	46	47	48	62	47	48	49	63	48	49	34	64	33	18	19	34	18	19	20	34	19	20	21	35	20	21	22	36	21	22	23	37	22	23	24	38	23	24	25	39	24	25	26	40	25	26	27	41	26	27	28	42	27	28	29	43	28	29	30	44	29	30	31	45	30	31	32	46	31	32	33	47	32	33	18	48	17	2	3	18	2	3	4	18	3	4	5	19	4	5	6	20	5	6	7	21	6	7	8	22	7	8	9	23	8	9	10	24	9	10	11	25	10	11	12	26	11	12	13	27	12	13	14	28	13	14	15	29	14	15	16	30	15	16	17	31	16	17	2	32	1	2	1	2	1	3	1	4	1	5	1	6	1	7	1	8	1	9	1	10	1	11	1	12	1	13	1	14	1	15	1	16
50	50	50	65	51	51	51	51	52	52	52	52	53	53	53	53	54	54	54	54	55	55	55	55	56	56	56	56	57	57	57	57	58	58	58	58	59	59	59	59	60	60	60	60	61	61	61	61	62	62	62	62	63	63	63	63	64	64	64	64	65	65	65	65	34	34	34	49	35	35	35	35	36	36	36	36	37	37	37	37	38	38	38	38	39	39	39	39	40	40	40	40	41	41	41	41	42	42	42	42	43	43	43	43	44	44	44	44	45	45	45	45	46	46	46	46	47	47	47	47	48	48	48	48	49	49	49	49	18	18	18	33	19	19	19	19	20	20	20	20	21	21	21	21	22	22	22	22	23	23	23	23	24	24	24	24	25	25	25	25	26	26	26	26	27	27	27	27	28	28	28	28	29	29	29	29	30	30	30	30	31	31	31	31	32	32	32	32	33	33	33	33	2	17	3	3	4	4	5	5	6	6	7	7	8	8	9	9	10	10	11	11	12	12	13	13	14	14	15	15	16	16	17	17
]'; % a matrix determining the connectivity plot in the ground structure (N_member rows, 2 columns)
%define grouped members in a matrix
sym_M=[
193	197	195	196	198	130	138	134	136	140	133	131	135	137	66	74	70	72	76	69	67	71	73	2	10	6	8	12	5	3	7	9
201	205	199	194	200	146	154	142	132	144	143	129	141	139	82	90	78	68	80	79	65	77	75	18	26	14	4	16	15	1	13	11
209	213	203	202	206	162	170	150	148	156	149	145	151	153	98	106	86	84	92	85	81	87	89	34	42	22	20	28	21	17	23	25
217	221	207	204	208	178	186	158	152	160	159	147	157	155	114	122	94	88	96	95	83	93	91	50	58	30	24	32	31	19	29	27
217	221	211	210	214	178	186	166	164	172	165	161	167	169	114	122	102	100	108	101	97	103	105	50	58	38	36	44	37	33	39	41
217	221	215	212	216	178	186	174	168	176	175	163	173	171	114	122	110	104	112	111	99	109	107	50	58	46	40	48	47	35	45	43
217	221	219	218	222	178	186	182	180	188	181	177	183	185	114	122	118	116	124	117	113	119	121	50	58	54	52	60	53	49	55	57
217	221	223	220	224	178	186	190	184	192	191	179	189	187	114	122	126	120	128	127	115	125	123	50	58	62	56	64	63	51	61	59
]; % topologically grouped members. 
sym_A=sym_M; % members with similar sections (In most test problems in the literature, sym_M=sym_A)
DOF_constrained=[(50:65)*3-2 (50:65)*3-1 (50:65)*3]; % DOFs anchored by the supports
% Define external load(s) applied to the structure
Fext=zeros(1,3*N_node)';
Fext([1 2 3])=[500 500 -1000]*1000; % D*N_node
%Define Mechanical Properties
M_elasticity=2e11;  %Modulus of elasticity
Fy=248.21e6; % Yield strength according to AISC-ASD 9th edition
Density=7850; % Density of truss material
dis_all=.01; % allowable displacement along each DOF 
% Now specify the list number for the given cross section. Store the cross sections in m-file sections.m. Use a number greater than 100 when AISC-ASD spcifications are employed.
section_no=101; % The available section list for this problem. 
% Specify the search range of shape variables. Only those corresponding the independent shape variables are important
Max_Kcond=1e14;

best_feas_design=[
0
0
10
-1.507998733
-1.507998733
7.181228608
-0.463438236
-1.910078491
7.181228608
0
-1.723646737
7.181228608
0.463438236
-1.910078491
7.181228608
1.507998733
-1.507998733
7.181228608
1.910078491
-0.463438236
7.181228608
1.723646737
0
7.181228608
1.910078491
0.463438236
7.181228608
1.507998733
1.507998733
7.181228608
0.463438236
1.910078491
7.181228608
0
1.723646737
7.181228608
-0.463438236
1.910078491
7.181228608
-1.507998733
1.507998733
7.181228608
-1.910078491
0.463438236
7.181228608
-1.723646737
0
7.181228608
-1.910078491
-0.463438236
7.181228608
-4.470546124
-4.470546124
5.612978017
-0.440578327
-2.801686113
5.612978017
0
-3.224119274
5.612978017
0.440578327
-2.801686113
5.612978017
4.470546124
-4.470546124
5.612978017
2.801686113
-0.440578327
5.612978017
3.224119274
0
5.612978017
2.801686113
0.440578327
5.612978017
4.470546124
4.470546124
5.612978017
0.440578327
2.801686113
5.612978017
0
3.224119274
5.612978017
-0.440578327
2.801686113
5.612978017
-4.470546124
4.470546124
5.612978017
-2.801686113
0.440578327
5.612978017
-3.224119274
0
5.612978017
-2.801686113
-0.440578327
5.612978017
-4.63097115
-4.63097115
2.73669258
-2.355568369
-7.791945008
2.73669258
0
-4.780078225
2.73669258
2.355568369
-7.791945008
2.73669258
4.63097115
-4.63097115
2.73669258
7.791945008
-2.355568369
2.73669258
4.780078225
0
2.73669258
7.791945008
2.355568369
2.73669258
4.63097115
4.63097115
2.73669258
2.355568369
7.791945008
2.73669258
0
4.780078225
2.73669258
-2.355568369
7.791945008
2.73669258
-4.63097115
4.63097115
2.73669258
-7.791945008
2.355568369
2.73669258
-4.780078225
0
2.73669258
-7.791945008
-2.355568369
2.73669258
-6.552008274
-6.552008274
0
-0.173022056
-6.577982566
0
0
-10
0
0.173022056
-6.577982566
0
6.552008274
-6.552008274
0
6.577982566
-0.173022056
0
10
0
0
6.577982566
0.173022056
0
6.552008274
6.552008274
0
0.173022056
6.577982566
0
0
10
0
-0.173022056
6.577982566
0
-6.552008274
6.552008274
0
-6.577982566
0.173022056
0
-10
0
0
-6.577982566
-0.173022056
0
0.001550207
0.000507252
0.001550207
0.000691366
0.000596847
0.000701347
0.003599993
0.000691366
0.001225613
0.000690321
0.001225613
0.000386079
0.003599993
0.000701347
0.000596847
0.000386079
0.001550207
0.000507252
0.001550207
0.000691366
0.000596847
0.000701347
0.003599993
0.000691366
0.001225613
0.000690321
0.001225613
0.000386079
0.003599993
0.000701347
0.000596847
0.000386079
0.001550207
0.000507252
0.001550207
0.000691366
0.000596847
0.000701347
0.003599993
0.000691366
0.001225613
0.000690321
0.001225613
0.000386079
0.003599993
0.000701347
0.000596847
0.000386079
0.001550207
0.000507252
0.001550207
0.000691366
0.000596847
0.000701347
0.003599993
0.000691366
0.001225613
0.000690321
0.001225613
0.000386079
0.003599993
0.000701347
0.000596847
0.000386079
0.001586332
0.000451404
0.001586332
0.001100951
0.001311529
0.001575107
0.001063198
0.001100951
0.002774188
0.001729029
0.002774188
0.000598914
0.001063198
0.001575107
0.001311529
0.000598914
0.001586332
0.000451404
0.001586332
0.001100951
0.001311529
0.001575107
0.001063198
0.001100951
0.002774188
0.001729029
0.002774188
0.000598914
0.001063198
0.001575107
0.001311529
0.000598914
0.001586332
0.000451404
0.001586332
0.001100951
0.001311529
0.001575107
0.001063198
0.001100951
0.002774188
0.001729029
0.002774188
0.000598914
0.001063198
0.001575107
0.001311529
0.000598914
0.001586332
0.000451404
0.001586332
0.001100951
0.001311529
0.001575107
0.001063198
0.001100951
0.002774188
0.001729029
0.002774188
0.000598914
0.001063198
0.001575107
0.001311529
0.000598914
0.00071733
0.001150129
0.00071733
0.000663227
0.000431612
0.002374189
0.000318709
0.000663227
0.000318709
0.001729029
0.000318709
0.000279354
0.000318709
0.002374189
0.000431612
0.000279354
0.00071733
0.001150129
0.00071733
0.000663227
0.000431612
0.002374189
0.000318709
0.000663227
0.000318709
0.001729029
0.000318709
0.000279354
0.000318709
0.002374189
0.000431612
0.000279354
0.00071733
0.001150129
0.00071733
0.000663227
0.000431612
0.002374189
0.000318709
0.000663227
0.000318709
0.001729029
0.000318709
0.000279354
0.000318709
0.002374189
0.000431612
0.000279354
0.00071733
0.001150129
0.00071733
0.000663227
0.000431612
0.002374189
0.000318709
0.000663227
0.000318709
0.001729029
0.000318709
0.000279354
0.000318709
0.002374189
0.000431612
0.000279354
0.000690321
0.00016129
0.002774188
0.00016129
0.001729029
0.000412257
0.002774188
0.000412257
0.000690321
0.00016129
0.002774188
0.00016129
0.001729029
0.000412257
0.002774188
0.000412257
0.000690321
0.00016129
0.002774188
0.00016129
0.001729029
0.000412257
0.002774188
0.000412257
0.000690321
0.00016129
0.002774188
0.00016129
0.001729029
0.000412257
0.002774188
0.000412257
0
0
0
0
0
0
1
0
0
1
0
0
1
0
0
0
0
0
0
0
0
0
1
0
0
1
0
0
1
0
0
0
0
0
0
0
0
0
1
0
0
1
0
0
1
0
0
0
0
0
0
0
0
0
1
0
0
1
0
0
1
0
0
0
0
0
0
0
0
0
0
0
1
1
1
0
0
0
0
0
0
0
0
0
0
0
0
0
1
1
1
0
0
0
0
0
0
0
0
0
0
0
0
0
1
1
1
0
0
0
0
0
0
0
0
0
0
0
0
0
1
1
1
0
0
0
0
0
0
0
0
0
1
1
1
0
1
1
1
1
1
1
1
1
0
0
0
0
1
1
1
0
1
1
1
1
1
1
1
1
0
0
0
0
1
1
1
0
1
1
1
1
1
1
1
1
0
0
0
0
1
1
1
0
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
3079.445544
];

 
        
X=best_feas_design(1:D*N_node)'; % Shape parameters
A=best_feas_design(D*N_node+(1:N_member))'; % Size Parameters
M=best_feas_design(D*N_node+N_member+(1:N_member))'; % Topology Parameters
NAP=find_NAP(GSCP,M); % Active nodes
Ri=find_Ri(A,section_no); 
[Length_M,Vol,displ_ratio,slender_ratio,stress_ratio,f_int_ext,displacement,f_int_unit]=FE_solve_2D3D_ASD(NAP,X,DOF_constrained,A,Ri,M,GSCP,Fext,M_elasticity,Fy,dis_all,Max_Kcond,D); 
clc
disp(['Maximum constraint ratio (must be equal to or less than one for a feasible design):'])
disp(['Max stress ratio: ' num2str(max(stress_ratio))]) 
disp(['Max slenderness ratio: ' num2str(max(slender_ratio))])
disp(['Max displacement ratio: ' num2str(max(displ_ratio))])
disp(['Structural weight: ' num2str(Vol*Density)])
plot_truss(GSCP,X,NAP,M,A,D);


