% Please read the readme.pdf file before using this code. 
clear;
D=2; %planar or spatial truss
N_node=59; % number of nodes in the ground structure
N_member=277; % number of nodes in the ground structure
GSCP=[
    1	1	1	1	1	2	2	2	2	2	3	3	3	3	4	4	4	5	5	5	5	5	5	5	6	6	6	6	6	6	7	7	7	7	7	8	8	8	8	8	9	9	9	9	10	10	10	11	11	11	11	11	11	11	12	12	12	12	12	12	13	13	13	13	13	14	14	14	14	14	15	15	15	15	16	16	16	17	17	17	17	17	17	17	18	18	18	18	18	18	19	19	19	19	19	20	20	20	20	20	21	21	21	21	22	22	22	23	23	23	23	23	23	23	24	24	24	24	24	24	25	25	25	25	25	26	26	26	26	26	27	27	27	27	28	28	28	29	29	29	29	29	29	29	30	30	30	30	30	30	31	31	31	31	31	32	32	32	32	32	33	33	33	33	34	34	34	35	35	35	35	35	35	35	36	36	36	36	36	36	37	37	37	37	37	38	38	38	38	38	39	39	39	39	40	40	40	41	41	41	41	41	41	41	42	42	42	42	42	42	43	43	43	43	43	44	44	44	44	44	45	45	45	45	46	46	46	47	47	47	47	47	47	47	48	48	48	48	48	48	49	49	49	49	49	50	50	50	50	50	51	51	51	51	52	52	52	53	53	53	53	53	54	54	54	54	54	55	55	55	55	56	56	56	57	57	58
    2	3	4	6	7	3	4	5	6	7	4	5	6	7	5	6	7	6	7	8	9	10	12	13	7	8	9	10	11	13	8	9	10	11	12	9	10	11	12	13	10	11	12	13	11	12	13	12	13	14	15	16	18	19	13	14	15	16	17	19	14	15	16	17	18	15	16	17	18	19	16	17	18	19	17	18	19	18	19	20	21	22	24	25	19	20	21	22	23	25	20	21	22	23	24	21	22	23	24	25	22	23	24	25	23	24	25	24	25	26	27	28	30	31	25	26	27	28	29	31	26	27	28	29	30	27	28	29	30	31	28	29	30	31	29	30	31	30	31	32	33	34	36	37	31	32	33	34	35	37	32	33	34	35	36	33	34	35	36	37	34	35	36	37	35	36	37	36	37	38	39	40	42	43	37	38	39	40	41	43	38	39	40	41	42	39	40	41	42	43	40	41	42	43	41	42	43	42	43	44	45	46	48	49	43	44	45	46	47	49	44	45	46	47	48	45	46	47	48	49	46	47	48	49	47	48	49	48	49	50	51	52	54	55	49	50	51	52	53	55	50	51	52	53	54	51	52	53	54	55	52	53	54	55	53	54	55	54	55	56	57	58	55	56	57	58	59	56	57	58	59	57	58	59	58	59	59
]'; % a matrix determining the connectivity plot in the ground structure (N_member rows, 2 columns)
%define grouped members in a matrix
sym_M=[
1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41	42	43	44	45	46	47	48	49	50	51	52	53	54	55	56	57	58	59	60	61	62	63	64	65	66	67	68	69	70	71	72	73	74	75	76	77	78	79	80	81	82	83	84	85	86	87	88	89	90	91	92	93	94	95	96	97	98	99	100	101	102	103	104	105	106	107	108	109	110	111	112	113	114	115	116	117	118	119	120	121	122	123	124	125	126	127	128	129	130	131	132	133	134	135	136	137
274	276	277	267	271	272	273	260	264	268	275	261	265	269	262	266	270	258	259	248	252	255	239	244	263	249	253	256	233	245	250	254	257	234	240	246	247	230	236	241	251	231	237	242	232	238	243	228	229	218	222	225	209	214	235	219	223	226	203	215	220	224	227	204	210	216	217	200	206	211	221	201	207	212	202	208	213	198	199	188	192	195	179	184	205	189	193	196	173	185	190	194	197	174	180	186	187	170	176	181	191	171	177	182	172	178	183	168	169	158	162	165	149	154	175	159	163	166	143	155	160	164	167	144	150	156	157	140	146	151	161	141	147	152	142	148	153
]; % topologically grouped members. 
sym_A=sym_M; % members with similar sections (In most test problems in the literature, sym_M=sym_A)
DOF_constrained=[1 2 118]; % DOFs anchored by the supports
% Define external load(s) applied to the structure
Fext=zeros(D*N_node,1);
Fext([  2:3:56 ]*2)=-60000;
%Define Mechanical Properties
M_elasticity=2.9e7;  %Modulus of elasticity
Fy=36000; % Yield strength according to AISC-ASD 9th edition
Density=.2836; % Density of truss material
dis_all=10; % allowable displacement along each DOF 
% Now specify the list number for the given cross section. Store the cross sections in m-file sections.m. Use a number greater than 100 when AISC-ASD spcifications are employed.
section_no=102; % The available section list for this problem. 
% Specify the search range of shape variables. Only those corresponding the independent shape variables are important
Max_Kcond=1e14;

best_feas_design=[
0
0
300
0
300
374.3568911
300
748.7137821
600
0
600
374.3568911
600
748.7137821
900
0
900
374.3568911
900
748.7137821
1200
0
1200
374.3568911
1200
748.7137821
1500
0
1500
374.3568911
1500
748.7137821
1800
0
1800
374.3568911
1800
748.7137821
2100
0
2100
374.3568911
2100
748.7137821
2400
0
2400
374.3568911
2400
748.7137821
2700
0
2700
374.3568911
2700
748.7137821
3000
0
3000
374.3568911
3000
748.7137821
3300
0
3300
374.3568911
3300
748.7137821
3600
0
3600
374.3568911
3600
748.7137821
3900
0
3900
374.3568911
3900
748.7137821
4200
0
4200
374.3568911
4200
748.7137821
4500
0
4500
374.3568911
4500
748.7137821
4800
0
4800
374.3568911
4800
748.7137821
5100
0
5100
374.3568911
5100
748.7137821
5400
0
5400
374.3568911
5400
748.7137821
5700
0
5700
374.3568911
5700
748.7137821
6000
0
21.8
68.5
67.68133384
25.06900003
197.8724588
6.49
29.03762169
21.8
8.571196082
25.33507888
13.25084651
9.71
11.5
61.8
20.79214229
14.49202898
17.7814067
6.49
16.25944804
21.8
15.78849829
27.77337094
25.24653063
55.69815457
23.2
9.71
9.764101029
42.7
14.4
51.65436245
15.68642018
15.74637078
26.5
29.58682091
12.19133234
15.67864861
19.14525681
24.1
18.94354738
36.20001189
10.32216173
12.52712441
9.660654275
15.04986014
17.06808757
19.1
56.8
9.71
28.15891815
31.2
20.0281894
36.75622385
17.634309
56.92310364
6.49
9.71
6.588013504
21.8
15.6
45.77679837
21.97939537
13.49885048
56.8
29.9759435
20.49105389
8.877186327
27.3258176
32.9
24.84674552
31.75958967
9.27123494
6.183683902
5.979705758
18.70131622
13.40679275
9.71
67.7
17
24.36668991
46.7
13.37139078
34.12445073
16.27593326
48.12033757
6.49
9.71
4.133338222
21.8
14.4
31.65089967
22.12402541
14.51365377
67.7
23.65641334
13.02401271
15.92686181
25.35858386
50
12.47161067
24.71981229
5.211236202
15.61742571
8.027720454
15.01248278
20.85499658
9.71
75.6
9.71
22.38313689
51.8
21.73025481
23.29974537
16.57854115
47.7651902
6.49
9.71
6.700863627
14.4
14.4
31.78517381
20.67016956
10.28720301
75.6
26.97706197
30.65566488
6.886639966
19.31138179
55.8
15.00388699
21.53723289
7.643687226
16.64245571
4.633155092
10.91393022
19.51356273
9.71
75.6
6.49
16.14337417
55.8
16.64245571
19.51356273
14.4
26.97706197
6.49
15.00388699
4.633155092
9.71
16.57854115
30.65566488
21.53723289
10.91393022
75.6
47.7651902
31.78517381
6.886639966
19.31138179
51.8
9.71
20.67016956
7.643687226
21.73025481
6.700863627
10.28720301
23.29974537
14.4
75.6
9.71
22.38313689
50
15.61742571
20.85499658
14.4
23.65641334
6.49
12.47161067
8.027720454
9.71
16.27593326
13.02401271
24.71981229
15.01248278
75.6
48.12033757
31.65089967
15.92686181
25.35858386
46.7
9.71
22.12402541
5.211236202
13.37139078
4.133338222
14.51365377
34.12445073
21.8
67.7
17
24.36668991
32.9
6.183683902
13.40679275
15.6
29.9759435
6.49
24.84674552
5.979705758
9.71
17.634309
20.49105389
31.75958967
18.70131622
67.7
56.92310364
45.77679837
8.877186327
27.3258176
31.2
9.71
21.97939537
9.27123494
20.0281894
6.588013504
13.49885048
36.75622385
21.8
56.8
9.71
28.15891815
24.1
12.52712441
17.06808757
14.4
29.58682091
6.49
18.94354738
9.660654275
19.1
25.24653063
12.19133234
36.20001189
15.04986014
56.8
55.69815457
51.65436245
15.67864861
19.14525681
21.8
9.71
15.68642018
10.32216173
15.78849829
9.764101029
15.74637078
27.77337094
42.7
26.5
6.49
16.25944804
21.8
9.71
20.79214229
23.2
8.571196082
11.5
14.49202898
25.06900003
25.33507888
61.8
17.7814067
197.8724588
6.49
29.03762169
21.8
13.25084651
68.5
67.68133384
1
1
0
0
0
1
0
1
0
0
0
1
1
1
0
0
0
1
0
1
0
0
0
0
1
1
0
1
1
0
0
0
1
0
0
0
0
1
0
0
0
0
0
0
0
1
1
1
0
1
0
0
0
0
1
1
0
1
1
0
0
0
1
0
0
0
0
1
0
0
0
0
0
0
0
1
1
1
0
1
0
0
0
0
1
1
0
1
1
0
0
0
1
0
0
0
0
1
0
0
0
0
0
0
0
1
1
1
0
1
0
0
0
0
1
1
0
1
1
0
0
0
1
0
0
0
0
1
0
0
0
0
0
0
0
1
1
1
0
1
0
0
1
0
1
0
0
1
0
0
0
0
1
0
0
0
0
1
1
0
0
0
0
0
0
1
1
1
0
1
0
0
1
0
1
0
0
1
0
0
0
0
1
0
0
0
0
1
1
0
0
0
0
0
0
1
1
1
0
1
0
0
1
0
1
0
0
1
0
0
0
0
1
0
0
0
0
1
1
0
0
0
0
0
0
1
1
1
0
1
0
0
1
0
1
0
0
1
0
0
0
0
1
0
0
0
0
1
1
0
0
0
0
0
0
1
1
1
0
1
1
0
1
0
1
0
0
0
1
0
0
1
0
1
0
1
0
282032.8812
];
        
X=best_feas_design(1:D*N_node)'; % Shape parameters
A=best_feas_design(D*N_node+(1:N_member))'; % Size Parameters
M=best_feas_design(D*N_node+N_member+(1:N_member))'; % Topology Parameters
NAP=find_NAP(GSCP,M); % Active nodes
Ri=find_Ri(A,section_no); 
[Length_M,Vol,displ_ratio,slender_ratio,stress_ratio,f_int_ext,displacement,f_int_unit]=FE_solve_2D3D_ASD(NAP,X,DOF_constrained,A,Ri,M,GSCP,Fext,M_elasticity,Fy,dis_all,Max_Kcond,D); 
clc
disp(['Maximum constraint ratio (must be equal to or less than one for a feasible design):'])
disp(['Max stress ratio: ' num2str(max(stress_ratio))]) 
disp(['Max slenderness ratio: ' num2str(max(slender_ratio))])
disp(['Max displacement ratio: ' num2str(max(displ_ratio))])
disp(['Structural weight: ' num2str(Vol*Density)])
plot_truss(GSCP,X,NAP,M,A,D);

disp('Check the readme file if slenderness_ratio is greater than 1 but equal to or smaller than 1.5')
