% Please read the readme.pdf file before using this code. 
clear;
D=2; %planar or spatial truss
N_node=59; % number of nodes in the ground structure
N_member=277; % number of nodes in the ground structure
GSCP=[
    1	1	1	1	1	2	2	2	2	2	3	3	3	3	4	4	4	5	5	5	5	5	5	5	6	6	6	6	6	6	7	7	7	7	7	8	8	8	8	8	9	9	9	9	10	10	10	11	11	11	11	11	11	11	12	12	12	12	12	12	13	13	13	13	13	14	14	14	14	14	15	15	15	15	16	16	16	17	17	17	17	17	17	17	18	18	18	18	18	18	19	19	19	19	19	20	20	20	20	20	21	21	21	21	22	22	22	23	23	23	23	23	23	23	24	24	24	24	24	24	25	25	25	25	25	26	26	26	26	26	27	27	27	27	28	28	28	29	29	29	29	29	29	29	30	30	30	30	30	30	31	31	31	31	31	32	32	32	32	32	33	33	33	33	34	34	34	35	35	35	35	35	35	35	36	36	36	36	36	36	37	37	37	37	37	38	38	38	38	38	39	39	39	39	40	40	40	41	41	41	41	41	41	41	42	42	42	42	42	42	43	43	43	43	43	44	44	44	44	44	45	45	45	45	46	46	46	47	47	47	47	47	47	47	48	48	48	48	48	48	49	49	49	49	49	50	50	50	50	50	51	51	51	51	52	52	52	53	53	53	53	53	54	54	54	54	54	55	55	55	55	56	56	56	57	57	58
    2	3	4	6	7	3	4	5	6	7	4	5	6	7	5	6	7	6	7	8	9	10	12	13	7	8	9	10	11	13	8	9	10	11	12	9	10	11	12	13	10	11	12	13	11	12	13	12	13	14	15	16	18	19	13	14	15	16	17	19	14	15	16	17	18	15	16	17	18	19	16	17	18	19	17	18	19	18	19	20	21	22	24	25	19	20	21	22	23	25	20	21	22	23	24	21	22	23	24	25	22	23	24	25	23	24	25	24	25	26	27	28	30	31	25	26	27	28	29	31	26	27	28	29	30	27	28	29	30	31	28	29	30	31	29	30	31	30	31	32	33	34	36	37	31	32	33	34	35	37	32	33	34	35	36	33	34	35	36	37	34	35	36	37	35	36	37	36	37	38	39	40	42	43	37	38	39	40	41	43	38	39	40	41	42	39	40	41	42	43	40	41	42	43	41	42	43	42	43	44	45	46	48	49	43	44	45	46	47	49	44	45	46	47	48	45	46	47	48	49	46	47	48	49	47	48	49	48	49	50	51	52	54	55	49	50	51	52	53	55	50	51	52	53	54	51	52	53	54	55	52	53	54	55	53	54	55	54	55	56	57	58	55	56	57	58	59	56	57	58	59	57	58	59	58	59	59
]'; % a matrix determining the connectivity plot in the ground structure (N_member rows, 2 columns)
%define grouped members in a matrix
sym_M=[
1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41	42	43	44	45	46	47	48	49	50	51	52	53	54	55	56	57	58	59	60	61	62	63	64	65	66	67	68	69	70	71	72	73	74	75	76	77	78	79	80	81	82	83	84	85	86	87	88	89	90	91	92	93	94	95	96	97	98	99	100	101	102	103	104	105	106	107	108	109	110	111	112	113	114	115	116	117	118	119	120	121	122	123	124	125	126	127	128	129	130	131	132	133	134	135	136	137
274	276	277	267	271	272	273	260	264	268	275	261	265	269	262	266	270	258	259	248	252	255	239	244	263	249	253	256	233	245	250	254	257	234	240	246	247	230	236	241	251	231	237	242	232	238	243	228	229	218	222	225	209	214	235	219	223	226	203	215	220	224	227	204	210	216	217	200	206	211	221	201	207	212	202	208	213	198	199	188	192	195	179	184	205	189	193	196	173	185	190	194	197	174	180	186	187	170	176	181	191	171	177	182	172	178	183	168	169	158	162	165	149	154	175	159	163	166	143	155	160	164	167	144	150	156	157	140	146	151	161	141	147	152	142	148	153
]; % topologically grouped members. 
sym_A=sym_M; % members with similar sections (In most test problems in the literature, sym_M=sym_A)
DOF_constrained=[1 2 118]; % DOFs anchored by the supports
% Define external load(s) applied to the structure
Fext=zeros(D*N_node,1);
Fext([  2:3:56 ]*2)=-60000;
%Define Mechanical Properties
M_elasticity=2.9e7;  %Modulus of elasticity
Fy=36000; % Yield strength according to AISC-ASD 9th edition
Density=.2836; % Density of truss material
dis_all=10; % allowable displacement along each DOF 
% Now specify the list number for the given cross section. Store the cross sections in m-file sections.m. Use a number greater than 100 when AISC-ASD spcifications are employed.
section_no=102; % The available section list for this problem. 
% Specify the search range of shape variables. Only those corresponding the independent shape variables are important
Max_Kcond=1e14;

best_feas_design=[
    0
0
300
0
300
157.1167287
300
314.2334575
600
0
600
242.6796324
600
485.3592649
900
0
900
308.7124565
900
617.424913
1200
0
1200
369.9483666
1200
739.8967333
1500
0
1500
415.2188676
1500
830.4377351
1800
0
1800
449.6141922
1800
899.2283844
2100
0
2100
475.3825365
2100
950.7650731
2400
0
2400
492.5055222
2400
985.0110444
2700
0
2700
496.6133823
2700
993.2267647
3000
0
3000
498.9864224
3000
997.9728448
3300
0
3300
496.6133823
3300
993.2267647
3600
0
3600
492.5055222
3600
985.0110444
3900
0
3900
475.3825365
3900
950.7650731
4200
0
4200
449.6141922
4200
899.2283844
4500
0
4500
415.2188676
4500
830.4377351
4800
0
4800
369.9483666
4800
739.8967333
5100
0
5100
308.7124565
5100
617.424913
5400
0
5400
242.6796324
5400
485.3592649
5700
0
5700
157.1167287
5700
314.2334575
6000
0
25.6
7.728412115
67.7
17.03284301
140.2284583
3.847757153
6.49
25.6
6.662103187
15.20962221
3.62773917
7.242197707
8.667161174
14.77420478
7.65
6.49
55.8
6.49
17.59408605
29.1
15.14017702
30.46561987
21.49317094
70.95251692
4.41
6.49
6.49
14.14174171
15.04049787
52.36295643
17.34005241
6.49
56.8
24.16864937
24.35616797
8.104573221
22.60056272
32.9
15.58837193
33.30043021
7.877778123
7.65
6.49
12.25888534
19.64639777
6.49
56.8
6.49
26.34754958
35.3
12.59034149
40.21585888
23.92132087
97.44047631
6.49
9.71
6.49
13.48493597
17.80651806
48.36277096
25.92549023
7.65
55.8
35.93833648
22.85872744
10.65023388
29.67814817
38.8
15.80729143
37.17801701
9.658025665
9.71
6.49
12.41719831
26.49103091
9.71
56.8
7.65
27.15551575
38.8
15.64858532
39.23329538
22.5051097
60.13531379
7.65
9.71
6.49
18.12220441
17.6450224
45.78701434
31.62243077
9.71
55.8
31.05999753
24.7442781
11.00119947
26.74019491
39.9
15.4153939
33.19893014
9.978997149
9.71
6.49
13.24420375
28.51730475
9.71
56.8
9.71
28.83420618
39.9
16.37613722
32.47552672
16.04845753
63.17176131
9.71
9.71
6.49
22.09871087
18.5010577
37.18018065
31.44736773
9.71
56.8
35.33048688
33.99974924
13.05611061
26.83515704
42.7
12.75224333
34.74202895
10.87290473
9.71
6.49
12.63976908
30.62317112
9.71
56.8
9.71
36.45818264
42.7
9.71
30.62317112
18.5010577
35.33048688
9.71
12.75224333
6.49
9.71
16.04845753
33.99974924
34.74202895
12.63976908
56.8
63.17176131
37.18018065
13.05611061
26.83515704
39.9
9.71
31.44736773
10.87290473
16.37613722
6.49
9.71
32.47552672
22.09871087
56.8
9.71
28.83420618
39.9
9.71
28.51730475
17.6450224
31.05999753
9.71
15.4153939
6.49
9.71
22.5051097
24.7442781
33.19893014
13.24420375
56.8
60.13531379
45.78701434
11.00119947
26.74019491
38.8
9.71
31.62243077
9.978997149
15.64858532
6.49
9.71
39.23329538
18.12220441
55.8
7.65
27.15551575
38.8
9.71
26.49103091
17.80651806
35.93833648
7.65
15.80729143
6.49
9.71
23.92132087
22.85872744
37.17801701
12.41719831
56.8
97.44047631
48.36277096
10.65023388
29.67814817
35.3
9.71
25.92549023
9.658025665
12.59034149
6.49
7.65
40.21585888
13.48493597
55.8
6.49
26.34754958
32.9
7.65
19.64639777
15.04049787
24.16864937
6.49
15.58837193
6.49
6.49
21.49317094
24.35616797
33.30043021
12.25888534
56.8
70.95251692
52.36295643
8.104573221
22.60056272
29.1
6.49
17.34005241
7.877778123
15.14017702
6.49
6.49
30.46561987
14.14174171
56.8
6.49
17.59408605
25.6
7.242197707
7.65
4.41
6.662103187
8.667161174
6.49
17.03284301
15.20962221
14.77420478
55.8
140.2284583
3.847757153
6.49
25.6
3.62773917
7.728412115
67.7
1
0
1
0
0
0
1
1
0
0
0
0
0
0
1
1
1
1
0
1
0
0
0
0
1
1
1
0
0
0
0
1
1
0
0
0
0
1
0
0
0
1
1
0
0
1
1
1
0
1
0
0
0
0
1
1
1
0
0
0
0
1
1
0
0
0
0
1
0
0
0
1
1
0
0
1
1
1
0
1
0
0
0
0
1
1
1
0
0
0
0
1
1
0
0
0
0
1
0
0
0
1
1
0
0
1
1
1
0
1
0
0
0
0
1
1
1
0
0
0
0
1
1
0
0
0
0
1
0
0
0
1
1
0
0
1
1
1
0
1
1
0
0
0
1
0
1
1
0
0
0
0
1
0
0
0
0
1
1
0
0
0
1
1
0
0
1
1
0
1
1
0
0
0
1
0
1
1
0
0
0
0
1
0
0
0
0
1
1
0
0
0
1
1
0
0
1
1
0
1
1
0
0
0
1
0
1
1
0
0
0
0
1
0
0
0
0
1
1
0
0
0
1
1
0
0
1
1
0
1
1
0
0
0
1
0
1
1
0
0
0
0
1
0
0
0
0
1
1
0
0
0
1
1
0
0
1
1
0
1
0
1
1
0
0
1
0
0
0
1
0
0
1
1
0
0
1
236543.282

];
        
X=best_feas_design(1:D*N_node)'; % Shape parameters
A=best_feas_design(D*N_node+(1:N_member))'; % Size Parameters
M=best_feas_design(D*N_node+N_member+(1:N_member))'; % Topology Parameters
NAP=find_NAP(GSCP,M); % Active nodes
Ri=find_Ri(A,section_no); 
[Length_M,Vol,displ_ratio,slender_ratio,stress_ratio,f_int_ext,displacement,f_int_unit]=FE_solve_2D3D_ASD(NAP,X,DOF_constrained,A,Ri,M,GSCP,Fext,M_elasticity,Fy,dis_all,Max_Kcond,D); 
clc
disp(['Maximum constraint ratio (must be equal to or less than one for a feasible design):'])
disp(['Max stress ratio: ' num2str(max(stress_ratio))]) 
disp(['Max slenderness ratio: ' num2str(max(slender_ratio))])
disp(['Max displacement ratio: ' num2str(max(displ_ratio))])
disp(['Structural weight: ' num2str(Vol*Density)])
plot_truss(GSCP,X,NAP,M,A,D);

disp('Check the readme file if slenderness_ratio is greater than 1 but equal to or smaller than 1.5')
