% Please read the readme.pdf file before using this code. 
clear;
D=2; %planar or spatial truss
N_node=59; % number of nodes in the ground structure
N_member=277; % number of nodes in the ground structure
GSCP=[
    1	1	1	1	1	2	2	2	2	2	3	3	3	3	4	4	4	5	5	5	5	5	5	5	6	6	6	6	6	6	7	7	7	7	7	8	8	8	8	8	9	9	9	9	10	10	10	11	11	11	11	11	11	11	12	12	12	12	12	12	13	13	13	13	13	14	14	14	14	14	15	15	15	15	16	16	16	17	17	17	17	17	17	17	18	18	18	18	18	18	19	19	19	19	19	20	20	20	20	20	21	21	21	21	22	22	22	23	23	23	23	23	23	23	24	24	24	24	24	24	25	25	25	25	25	26	26	26	26	26	27	27	27	27	28	28	28	29	29	29	29	29	29	29	30	30	30	30	30	30	31	31	31	31	31	32	32	32	32	32	33	33	33	33	34	34	34	35	35	35	35	35	35	35	36	36	36	36	36	36	37	37	37	37	37	38	38	38	38	38	39	39	39	39	40	40	40	41	41	41	41	41	41	41	42	42	42	42	42	42	43	43	43	43	43	44	44	44	44	44	45	45	45	45	46	46	46	47	47	47	47	47	47	47	48	48	48	48	48	48	49	49	49	49	49	50	50	50	50	50	51	51	51	51	52	52	52	53	53	53	53	53	54	54	54	54	54	55	55	55	55	56	56	56	57	57	58
    2	3	4	6	7	3	4	5	6	7	4	5	6	7	5	6	7	6	7	8	9	10	12	13	7	8	9	10	11	13	8	9	10	11	12	9	10	11	12	13	10	11	12	13	11	12	13	12	13	14	15	16	18	19	13	14	15	16	17	19	14	15	16	17	18	15	16	17	18	19	16	17	18	19	17	18	19	18	19	20	21	22	24	25	19	20	21	22	23	25	20	21	22	23	24	21	22	23	24	25	22	23	24	25	23	24	25	24	25	26	27	28	30	31	25	26	27	28	29	31	26	27	28	29	30	27	28	29	30	31	28	29	30	31	29	30	31	30	31	32	33	34	36	37	31	32	33	34	35	37	32	33	34	35	36	33	34	35	36	37	34	35	36	37	35	36	37	36	37	38	39	40	42	43	37	38	39	40	41	43	38	39	40	41	42	39	40	41	42	43	40	41	42	43	41	42	43	42	43	44	45	46	48	49	43	44	45	46	47	49	44	45	46	47	48	45	46	47	48	49	46	47	48	49	47	48	49	48	49	50	51	52	54	55	49	50	51	52	53	55	50	51	52	53	54	51	52	53	54	55	52	53	54	55	53	54	55	54	55	56	57	58	55	56	57	58	59	56	57	58	59	57	58	59	58	59	59
]'; % a matrix determining the connectivity plot in the ground structure (N_member rows, 2 columns)
%define grouped members in a matrix
sym_M=[
1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	31	32	33	34	35	36	37	38	39	40	41	42	43	44	45	46	47	48	49	50	51	52	53	54	55	56	57	58	59	60	61	62	63	64	65	66	67	68	69	70	71	72	73	74	75	76	77	78	79	80	81	82	83	84	85	86	87	88	89	90	91	92	93	94	95	96	97	98	99	100	101	102	103	104	105	106	107	108	109	110	111	112	113	114	115	116	117	118	119	120	121	122	123	124	125	126	127	128	129	130	131	132	133	134	135	136	137
274	276	277	267	271	272	273	260	264	268	275	261	265	269	262	266	270	258	259	248	252	255	239	244	263	249	253	256	233	245	250	254	257	234	240	246	247	230	236	241	251	231	237	242	232	238	243	228	229	218	222	225	209	214	235	219	223	226	203	215	220	224	227	204	210	216	217	200	206	211	221	201	207	212	202	208	213	198	199	188	192	195	179	184	205	189	193	196	173	185	190	194	197	174	180	186	187	170	176	181	191	171	177	182	172	178	183	168	169	158	162	165	149	154	175	159	163	166	143	155	160	164	167	144	150	156	157	140	146	151	161	141	147	152	142	148	153
]; % topologically grouped members. 
sym_A=sym_M; % members with similar sections (In most test problems in the literature, sym_M=sym_A)
DOF_constrained=[1 2 118]; % DOFs anchored by the supports
% Define external load(s) applied to the structure
Fext=zeros(D*N_node,1);
Fext([  2:3:56 ]*2)=-60000;
%Define Mechanical Properties
M_elasticity=2.9e7;  %Modulus of elasticity
Fy=36000; % Yield strength according to AISC-ASD 9th edition
Density=.2836; % Density of truss material
dis_all=10; % allowable displacement along each DOF 
% Now specify the list number for the given cross section. Store the cross sections in m-file sections.m. Use a number greater than 100 when AISC-ASD spcifications are employed.
section_no=102; % The available section list for this problem. 
% Specify the search range of shape variables. Only those corresponding the independent shape variables are important
Max_Kcond=1e14;

best_feas_design=[
0
0
300
0
208.020924
289.4004256
514.5438289
463.2136932
600
0
879.8288521
646.4993541
623.3464877
186.6730371
900
0
819.5504217
62.1127645
1107.381499
433.9653778
1200
0
1480.944835
233.4235928
1227.995957
749.9680019
1500
0
1544.227995
455.4097089
1633.329235
836.1589852
1800
0
2085.646721
921.1113775
1790.756819
146.5954992
2100
0
2243.268885
179.8398086
1922.119314
258.7591735
2400
0
2571.263758
58.83824095
2549.468709
935.1353141
2700
0
2848.701763
162.7060366
2615.870824
378.1505062
3000
0
3000
944.2836555
3000
499.2942422
3300
0
3151.298237
162.7060366
3384.129176
378.1505062
3600
0
3428.736242
58.83824095
3450.531291
935.1353141
3900
0
3756.731115
179.8398086
4077.880686
258.7591735
4200
0
3914.353279
921.1113775
4209.243181
146.5954992
4500
0
4455.772005
455.4097089
4366.670765
836.1589852
4800
0
4519.055165
233.4235928
4772.004043
749.9680019
5100
0
5180.449578
62.1127645
4892.618501
433.9653778
5400
0
5120.171148
646.4993541
5376.653512
186.6730371
5700
0
5791.979076
289.4004256
5485.456171
463.2136932
6000
0
19.1
50
39.82664494
122.7905028
15.06872429
6.49
15.07826284
20
26.63709595
7.616907746
55.8
9.71
58.39539042
8.79
13.67732728
62
6.49
22.39945872
6.49
20
4.99
20.77259379
21.12050407
34.37110368
15.63825145
17.74215914
15.52161831
7.61
20.016019
61.8
6.49
5.57
18.40377136
14.58629763
17.25891039
4.011606275
13.89888913
24.1
9.210283694
26.87827519
12.81837077
9.71
12.7239807
35.04586614
7.65
7.65
9.71
6.49
26.82427949
32.9
16.07104146
21.67233553
29.81075089
13.81019336
15.91612753
3.54
3.54
25.03277666
8.043361061
7.61
21.73024216
7.65
75.6
25.01657358
38.45973049
10.54868205
23.59413959
28.2
26.7342661
6.49
6.49
10.61154012
24.52976648
6.49
19.0967367
83.3
13.68741565
22.5494978
3.54
28.2
7.172060817
8.520992589
17.9666915
30.02831732
23.50001292
21.63251997
14.4
19.02623555
27.08297301
83.3
6.49
10
5.595033709
13.01225099
15.97585672
3.54
8.674002024
32.9
7.465189828
26.6687271
6.942044453
4.41
11.2
23.14906771
11.48791455
13.66031298
29.3236982
3.54
24.1797933
32
7.888685336
10.19787369
27.36730685
22.79881466
21.75651997
4.41
5.302395698
6.49
8.79
17.03784891
25.52768139
20.4480798
9.71
27.73554599
83.3
3.54
6.49
35.3
25.87371828
13.93912142
7.529262961
3.54
20.93011866
6.49
14.27299393
22.94062484
9.476314883
24.84049608
10.48522967
35.3
3.54
14.27299393
8.79
27.73554599
7.65
25.87371828
20.93011866
22.94062484
27.36730685
83.3
13.93912142
6.49
9.476314883
22.79881466
17.03784891
3.54
6.49
32
4.41
25.52768139
7.529262961
7.888685336
5.302395698
20.4480798
10.19787369
6.49
9.71
3.54
24.1797933
32.9
4.41
11.48791455
27.08297301
13.01225099
21.75651997
7.465189828
11.2
13.66031298
17.9666915
15.97585672
26.6687271
23.14906771
29.3236982
30.02831732
83.3
3.54
8.674002024
28.2
21.63251997
6.49
6.942044453
7.172060817
14.4
10
8.520992589
19.02623555
5.595033709
22.5494978
3.54
28.2
10.61154012
19.0967367
8.043361061
25.01657358
23.50001292
26.7342661
24.52976648
83.3
29.81075089
38.45973049
6.49
6.49
13.68741565
13.81019336
7.61
10.54868205
23.59413959
32.9
3.54
21.73024216
6.49
16.07104146
3.54
7.65
21.67233553
25.03277666
75.6
6.49
26.82427949
24.1
9.71
7.65
20.016019
14.58629763
15.91612753
9.210283694
12.7239807
7.65
21.12050407
17.25891039
26.87827519
35.04586614
9.71
34.37110368
61.8
4.011606275
13.89888913
20
17.74215914
6.49
12.81837077
4.99
15.52161831
5.57
20.77259379
7.61
18.40377136
22.39945872
6.49
20
9.71
13.67732728
15.63825145
26.63709595
58.39539042
62
122.7905028
7.616907746
8.79
6.49
15.06872429
6.49
15.07826284
19.1
55.8
50
39.82664494
1
1
0
0
0
1
0
1
0
0
1
1
0
1
0
1
1
0
1
1
1
0
0
0
0
0
0
1
0
1
1
1
0
0
0
0
0
1
0
0
0
1
0
0
1
1
1
1
0
1
0
0
0
0
0
1
1
0
0
1
0
1
1
0
0
0
0
1
0
1
1
0
0
1
0
1
0
0
1
1
0
0
0
0
0
0
1
0
0
1
1
1
0
0
0
1
0
1
0
0
0
1
1
0
0
0
0
1
0
1
0
0
0
0
0
1
0
1
1
0
0
0
1
0
1
1
1
1
0
0
0
1
0
1
0
0
0
0
0
1
1
0
1
0
1
0
0
0
0
1
0
1
0
0
0
1
1
1
1
0
0
0
0
0
0
1
1
1
0
1
1
0
0
0
0
0
1
0
0
0
0
0
0
0
1
1
0
1
0
1
0
0
1
1
0
0
0
0
1
1
0
0
0
0
0
0
0
1
0
0
1
1
0
0
1
0
0
1
1
0
1
0
1
1
0
0
1
1
0
1
1
1
0
0
0
0
0
1
0
0
0
0
1
0
1
0
0
1
0
1
0
1
0
1
0
1
0
0
1
1
1
0
0
0
0
1
0
0
1
1
0
1
0
1
1
1
0
231943.3125

];
        
X=best_feas_design(1:D*N_node)'; % Shape parameters
A=best_feas_design(D*N_node+(1:N_member))'; % Size Parameters
M=best_feas_design(D*N_node+N_member+(1:N_member))'; % Topology Parameters
NAP=find_NAP(GSCP,M); % Active nodes
Ri=find_Ri(A,section_no); 
[Length_M,Vol,displ_ratio,slender_ratio,stress_ratio,f_int_ext,displacement,f_int_unit]=FE_solve_2D3D_ASD(NAP,X,DOF_constrained,A,Ri,M,GSCP,Fext,M_elasticity,Fy,dis_all,Max_Kcond,D); 
clc
disp(['Maximum constraint ratio (must be equal to or less than one for a feasible design):'])
disp(['Max stress ratio: ' num2str(max(stress_ratio))]) 
disp(['Max slenderness ratio: ' num2str(max(slender_ratio))])
disp(['Max displacement ratio: ' num2str(max(displ_ratio))])
disp(['Structural weight: ' num2str(Vol*Density)])
plot_truss(GSCP,X,NAP,M,A,D);

disp('Check the readme file if slenderness_ratio is greater than 1 but equal to or smaller than 1.5')
