% Please read the readme.pdf file before using this code. 
clear;
D=2; %planar or spatial truss
N_node=12; % number of nodes in the ground structure
N_member=39; % number of nodes in the ground structure
GSCP=[ 1	1	1	1	2	2	2	2	2	3	3	3	3	3	3	3	3	4	4	4	4	4	5	5	5	6	6	6	7	7	7	8	8	8	9	9	10	10	11
     2	8	9	12	3	8	9	11	12	4	6	7	8	9	10	11	12	5	6	7	10	11	6	7	10	7	10	11	8	10	11	9	11	12	11	12	11	12	12
     ]';% a matrix determining the connectivity plot in the ground structure (N_member rows, 2 columns)
%define grouped members in a matrix
%sym_M=[1 2;1 2]; % topologically grouped members. 
%sym_A=sym_M; % members with similar sections (In most test problems in the literature, sym_M=sym_A)
DOF_constrained=[1 2  10]; % DOFs anchored by the supports
% Define external load(s) applied to the structure
Fext=zeros(1,2*N_node)';
Fext([ 4 6 8 ])=-20e3*ones(3,1);


%Define Mechanical Properties
M_elasticity=1e7;  %modulus of elasticity
SigT_all=20e3; % tensile strength
SigC_all=20e3; % comprehessive strength
Density=0.1; % density of truss material
kappa=1e10; % The parameter in the elastic buckling equation ( sigma_c<=kappa*EI/l^2)
dis_all=2; % allowable displacement along each DOF. If there is no displacement, set dis_all=1e12 
%section_no=7; % The avilable section list for this problem. (see sections.m)
SF_buck=pi^2/kappa; 
Max_Kcond=1e14;

best_feas_design=[
0
0
120
0
240
0
360
0
480
0
474.8087
84.2778
426.0103
151.2525
53.9897
151.2525
5.1913
84.2778
307.9806
210.2555
240
219.9569
172.0194
210.2555
0.092395813
0.050000363
1.502842968
0.057008163
0.979806549
0.559606571
0.823167751
0.051618298
0.054658115
0.979806549
0.0539824
0.054439275
0.054439275
0.0539824
0.361835248
0.31142618
0.361835248
0.092395813
0.823167751
0.559606571
0.054658115
0.051618298
1.502842968
0.050000363
0.057008163
1.215911196
0.050054815
0.057629748
0.059470708
1.05075461
0.067927674
1.215911196
0.067927674
1.05075461
0.057629748
0.050054815
1.102177465
0.098806017
1.102177465
1
0
1
0
1
1
1
0
0
1
0
0
0
0
1
1
1
1
1
1
0
0
1
0
0
1
1
0
0
1
0
1
0
1
0
1
1
0
1

];

 
        
X=best_feas_design(1:D*N_node)'; % Shape parameters
A=best_feas_design(D*N_node+(1:N_member))'; % Size Parameters
M=best_feas_design(D*N_node+N_member+(1:N_member))'; % Topology Parameters
NAP=find_NAP(GSCP,M); % Active nodes
[Length_M,Vol,displ_ratio,buck_ratio,   stress_ratio,f_int_ext,displacement,f_int_unit]=FE_solve_2D3D_simp(NAP,X,DOF_constrained,A,   M,GSCP,Fext,M_elasticity,SigT_all,SigC_all,dis_all,Max_Kcond,D); 
buck_ratio= sqrt(SF_buck*buck_ratio);


clc
disp(['Maximum constraint ratio (must be equal to or less than one for a feasible design):'])
disp(['Max stress ratio: ' num2str(max(stress_ratio))]) 
disp(['Max buckling ratio: ' num2str(max(buck_ratio))])
disp(['Max displacement ratio: ' num2str(max(displ_ratio))])
disp(['Structural weight: ' num2str(Vol*Density)])
plot_truss(GSCP,X,NAP,M,A,D);


