% Please read the readme.pdf file before using this code. 
clear;
D=2; %planar or spatial truss
N_node=22; % number of nodes in the ground structure
N_member=47; % number of nodes in the ground structure
GSCP=[
       1	2	2	1	3	4	4	3	5	6	6	5	7	8	7	8	9	10	10	9	11	12	12	11	13	14	13	14	19	20	15	16	15	16	17	18	15	16	14	13	21	13	11	9	7	5	3
       3	4	3	4	5	6	5	6	7	8	7	8	9	10	10	9	11	12	11	12	13	14	13	14	21	22	15	16	21	22	19	20	21	22	19	20	17	18	21	22	22	14	12	10	8	6	4
   ]'; % a matrix determining the connectivity plot in the ground structure (N_member rows, 2 columns)
%define grouped members in a matrix
sym_M=[2	1	4	3	11	10	13	12	20	19	22	21	29	28	31	30	38	37	40	39	47	46	49	48	56	55	58	57	65	64	67	66	74	73	79	78	81	80	83	82	84	92	93	94	95	100	101	104	105	109
5	6	7	8	14	15	16	17	23	24	25	26	32	33	34	35	41	42	43	44	50	51	52	53	59	60	61	62	68	69	70	71	75	76	85	86	87	88	89	90	91	96	97	98	99	102	103	106	107	110
]; % topologically grouped members. 
sym_A=sym_M; % members with similar sections (In most test problems in the literature, sym_M=sym_A)
DOF_constrained=[1:4]; % DOFs anchored by the supports
% Define external load(s) applied to the structure
Fext=zeros(3,D*N_node)';
Fext([ 33 34 ],1)=[6000 -14000];
Fext([ 35 36 ],2)=[6000 -14000];
Fext([33:36 ],3)=[6000 -14000 6000 -14000];

%Define Mechanical Properties
M_elasticity=3e7;  %modulus of elasticity
SigT_all=20e3; % tensile strength
SigC_all=15e3; % comprehessive strength
Density=0.3; % density of truss material
kappa=3.96; % The parameter in the elastic buckling equation ( sigma_c<=kappa*EI/l^2)
dis_all=1e12; % allowable displacement along each DOF. If there is no displacement, set dis_all=1e12 
%section_no=7; % The avilable section list for this problem. (see sections.m)
SF_buck=pi^2/kappa; 
Max_Kcond=1e14;

best_feas_design=[
-127.4263464
0
127.4263464
0
-98.27665268
151.3320342
98.27665268
151.3320342
-76.49380288
260.4375111
76.49380288
260.4375111
-64.17954103
370.620339
64.17954103
370.620339
-53.70585229
435.5194236
53.70585229
435.5194236
-44.61864529
513.943376
44.61864529
513.943376
-53.55895548
536.8634594
53.55895548
536.8634594
-90
570
90
570
-150
600
150
600
-102.845902
628.4528734
102.845902
628.4528734
-10.37775739
618.1615906
10.37775739
618.1615906
3
3
0.3
0.3
2.6
2.6
1.5
1.5
2.8
2.8
0.6
0.6
2.3
2.3
1.1
1.1
2.5
2.5
0.6
0.6
2.3
2.3
1.4
1.4
0.7
0.7
1.6
1.6
0.9
0.9
0.8
0.8
0.2
0.2
0.9
0.9
1.2
1.2
1.1
1.1
1.2
1.192217573
0.478738214
0.461191092
0.212106698
0.62601454
0.202622827
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
0
0
0
0
0
0
1727.624158

];

 
        
X=best_feas_design(1:D*N_node)'; % Shape parameters
A=best_feas_design(D*N_node+(1:N_member))'; % Size Parameters
M=best_feas_design(D*N_node+N_member+(1:N_member))'; % Topology Parameters
NAP=find_NAP(GSCP,M); % Active nodes
[Length_M,Vol,displ_ratio,buck_ratio,   stress_ratio,f_int_ext,displacement,f_int_unit]=FE_solve_2D3D_simp(NAP,X,DOF_constrained,A,   M,GSCP,Fext,M_elasticity,SigT_all,SigC_all,dis_all,Max_Kcond,D); 
buck_ratio= sqrt(SF_buck*buck_ratio);


clc
disp(['Maximum constraint ratio (must be equal to or less than one for a feasible design):'])
disp(['Max stress ratio: ' num2str(max(stress_ratio))]) 
disp(['Max buckling ratio: ' num2str(max(buck_ratio))])
disp(['Max displacement ratio: ' num2str(max(displ_ratio))])
disp(['Structural weight: ' num2str(Vol*Density)])
plot_truss(GSCP,X,NAP,M,A,D);


