% Please read the readme.pdf file before using this code. 
clear;
D=2; %planar or spatial truss
N_node=18; % number of nodes in the ground structure
N_member=68; % number of nodes in the ground structure
GSCP=[
      1	2	1	1	2	2	2	3	4	5	4	4	5	5	5	6	7	8	7	7	8	8	8	9	10	11	10	10	11	11	11	12	13	14	13	13	14	14	14	15	16	17	3	1	6	4	9	7	12	10	15	13	1	3	2	2	4	6	5	5	7	9	8	8	10	12	11	11
      2	3	4	5	4	5	6	6	5	6	7	8	7	8	9	9	8	9	10	11	10	11	12	12	11	12	13	14	13	14	15	15	14	15	16	17	16	17	18	18	17	18	4	6	7	9	10	12	13	15	16	18	8	8	7	9	11	11	10	12	14	14	13	15	17	17	16	18
]'; % a matrix determining the connectivity plot in the ground structure (N_member rows, 2 columns)
%define grouped members in a matrix
sym_M=[1 2;1 2]; % topologically grouped members. 
sym_A=sym_M; % members with similar sections (In most test problems in the literature, sym_M=sym_A)
DOF_constrained=[1 2  5]; % DOFs anchored by the supports
% Define external load(s) applied to the structure
Fext1=zeros(1,2*N_node)';
Fext1(33)=-50e3;
Fext2=Fext1;
Fext2(34)=-15e3;
Fext=[Fext1 Fext2];


%Define Mechanical Properties
M_elasticity=3e7;  %modulus of elasticity
SigT_all=20e3; % tensile strength
SigC_all=20e3; % comprehessive strength
Density=0.3; % density of truss material
kappa=3.96; % The parameter in the elastic buckling equation ( sigma_c<=kappa*EI/l^2)
dis_all=2.5; % allowable displacement along each DOF. If there is no displacement, set dis_all=1e12 
%section_no=7; % The avilable section list for this problem. (see sections.m)
SF_buck=pi^2/kappa; 
Max_Kcond=1e14;

best_feas_design=[
0
-40
77.15778725
2.240535381
0
40
102.4784237
-63.29906279
149.6679868
39.50445669
112.368726
69.87728914
206.2894808
-62.87079852
284.3748393
-20.56693199
219.2913296
54.04473709
308.3324608
-50.95028389
372.474247
21.14486543
331.5007303
58.39567303
430.5698624
-15.65116857
512.1632516
23.35728316
445.3260187
48.99758811
518.8603417
-0.054625078
600
37.9420202
522.8007491
60.28648765
3.131
1.333
3.131
2.515732077
0.539
1.333
1.081
2.142
0.347
0.347
3.131
0.809810161
0.44
0.552024798
1.081
1.488
0.27
0.44
2.8
0.159021249
0.44
0.111
0.27
2.142
0.129791916
0.111
2.697
1.998327581
0.111
0.933806427
0.344937628
2.142
1.333
0.954
1.333
2.826132698
0.347
1.333
0.539
1.174
1.333
1.081
1.089158381
2.31046019
0.184711373
0.365884099
0.111
0.389842241
0.132353257
0.564122381
0.299642571
0.671922965
3.020134158
2.11462132
1.164903519
1.803936415
1.400386874
1.399579732
1.156573555
1.66614988
3.401163018
2.920198908
0.554246796
0.877874433
4.86830195
4.510913355
0.851170375
0.999725304
1
1
1
0
1
1
1
1
1
1
1
0
1
0
1
1
1
1
1
0
1
1
1
1
0
1
1
0
1
0
0
1
1
1
1
0
1
1
1
1
1
1
0
0
0
0
1
0
0
0
0
0
0
0
0
0
0
0
0
0
0
0
0
0
0
0
0
0
1166.062432
];

 
        
X=best_feas_design(1:D*N_node)'; % Shape parameters
A=best_feas_design(D*N_node+(1:N_member))'; % Size Parameters
M=best_feas_design(D*N_node+N_member+(1:N_member))'; % Topology Parameters
NAP=find_NAP(GSCP,M); % Active nodes
[Length_M,Vol,displ_ratio,buck_ratio,   stress_ratio,f_int_ext,displacement,f_int_unit]=FE_solve_2D3D_simp(NAP,X,DOF_constrained,A,   M,GSCP,Fext,M_elasticity,SigT_all,SigC_all,dis_all,Max_Kcond,D); 
buck_ratio= sqrt(SF_buck*buck_ratio);


clc
disp(['Maximum constraint ratio (must be equal to or less than one for a feasible design):'])
disp(['Max stress ratio: ' num2str(max(stress_ratio))]) 
disp(['Max buckling ratio: ' num2str(max(buck_ratio))])
disp(['Max displacement ratio: ' num2str(max(displ_ratio))])
disp(['Structural weight: ' num2str(Vol*Density)])
plot_truss(GSCP,X,NAP,M,A,D);


