% Please read the readme.pdf file before using this code. 
clear;
D=2; %planar or spatial truss
N_node=40; % number of nodes in the ground structure
N_member=77; % number of nodes in the ground structure
GSCP=[
1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,20,21,22,22,22,23,24,24,24,25,26,26,26,27,28,28,28,29,30,30,30,31,32,32,32,33,34,34,34,35,36,36,36,37,38,38,39
2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,16,16,17,17,18,18,19,19,20,20,21,21,22,23,23,23,24,25,25,25,26,27,27,27,28,29,29,29,30,31,31,31,32,33,33,33,34,35,35,35,36,37,37,37,38,39,39,39,40,40
]'; % a matrix determining the connectivity plot in the ground structure (N_member rows, 2 columns)
%define grouped members in a matrix
sym_M=[
1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38
76,77,75,72,73,74,71,68,69,70,67,64,65,66,63,60,61,62,59,56,57,58,55,52,53,54,51,48,49,50,47,44,45,46,43,40,41,42
]; % topologically grouped members. 
sym_A=sym_M; % members with similar sections (In most test problems in the literature, sym_M=sym_A)
DOF_constrained=[1 2 80]; % DOFs anchored by the supports
% Define external load(s) applied to the structure
Fext=zeros(1,D*N_node)';
Fext([4:4:76])=-60000*ones(1,19);

%Define Mechanical Properties
M_elasticity=2.9e7;  %Modulus of elasticity
Fy=36000; % Yield strength according to AISC-ASD 9th edition
Density=.2836; % Density of truss material
dis_all=10; % allowable displacement along each DOF 
% Now specify the list number for the given cross section. Store the cross sections in m-file sections.m. Use a number greater than 100 when AISC-ASD spcifications are employed.
section_no=102; % The available section list for this problem. 
% Specify the search range of shape variables. Only those corresponding the independent shape variables are important
Max_Kcond=1e14;

best_feas_design=[
0
0
300
0
300
224.3470799
600
0
600
321.3699908
900
0
900
431.3147097
1200
0
1200
521.0022166
1500
0
1500
592.1480146
1800
0
1800
650.3289706
2100
0
2100
703.318113
2400
0
2400
741.9564586
2700
0
2700
761.865383
3000
0
3000
765.6767426
3300
0
3300
761.865383
3600
0
3600
741.9564586
3900
0
3900
703.318113
4200
0
4200
650.3289706
4500
0
4500
592.1480146
4800
0
4800
521.0022166
5100
0
5100
431.3147097
5400
0
5400
321.3699908
5700
0
5700
224.3470799
6000
0
35.3
68.5
3.54
35.3
14.4
68.5
14.4
46.7
7.65
75.6
7.65
50
9.71
75.6
9.71
51.8
13.3
75.6
11.5
55.8
14.4
75.6
14.4
55.8
14.4
75.6
14.4
55.8
15.8
75.6
14.4
55.8
21.8
75.6
14.4
56.8
21.8
75.6
15.8
56.8
21.8
75.6
14.4
55.8
21.8
75.6
14.4
55.8
15.8
75.6
14.4
55.8
14.4
75.6
14.4
55.8
14.4
75.6
11.5
51.8
13.3
75.6
9.71
50
9.71
75.6
7.65
46.7
7.65
75.6
14.4
35.3
14.4
68.5
3.54
35.3
68.5
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
1
305963.9707

];

 
        
X=best_feas_design(1:D*N_node)'; % Shape parameters
A=best_feas_design(D*N_node+(1:N_member))'; % Size Parameters
M=best_feas_design(D*N_node+N_member+(1:N_member))'; % Topology Parameters
NAP=find_NAP(GSCP,M); % Active nodes
Ri=find_Ri(A,section_no); 
[Length_M,Vol,displ_ratio,slender_ratio,stress_ratio,f_int_ext,displacement,f_int_unit]=FE_solve_2D3D_ASD(NAP,X,DOF_constrained,A,Ri,M,GSCP,Fext,M_elasticity,Fy,dis_all,Max_Kcond,D); 
clc
disp(['Maximum constraint ratio (must be equal to or less than one for a feasible design):'])
disp(['Max stress ratio: ' num2str(max(stress_ratio))]) 
disp(['Max slenderness ratio: ' num2str(max(slender_ratio))])
disp(['Max displacement ratio: ' num2str(max(displ_ratio))])
disp(['Structural weight: ' num2str(Vol*Density)])
plot_truss(GSCP,X,NAP,M,A,D);


