function plot_truss(TA,nodes,NAP,AAP,A,D)
% this function plot the truss. sections that eventually do not exist are
% red.
maxA=max(A.*AAP);
thick=A./maxA.*4;

X=nodes(1:D:end);
Y=nodes(2:D:end);
if D==3
    Z=nodes(3:D:end);
else
    Z=X*0;
end
hold on
 for k=1:numel(AAP)
     if AAP(k)==1
         points=TA(k,:);
         plot3(X(points),Y(points),Z(points),'b','LineWidth',thick(k)^1);
     else
         points=TA(k,:);
        % plot3(X(points),Y(points),Z(points),'r-','LineWidth',4);
     end
 end
 if D==2
     view(0,90)
 else
     view(-37.5,30)
 end
 for k=1:numel(NAP)
     if NAP(k)==1
         plot3(X(k),Y(k),Z(k),'*g');
     else
    %     plot3(X(k),Y(k),Z(k),'*r','MarkerSize',10);
         
 
     end
 end
 view(0,90)