load data
load preliminary_results 

% fun = @DAEs;
colors = [0 0.447 0.741; 0.85 0.325 0.098; 0.929 0.694 0.125; 0.494 0.184 0.556; 0.466 0.674 0.188; 0.3010 0.7450 0.9330; 0.6350 0.0780 0.1840;...
    0.0745 0.6235 1.0000; 1.0000 0.4118 0.1608; 0.3922 0.8314 0.0745; 0.7176 0.2745 1.0000];

%% MODEL CALIBRATION
%% FIG 2: In-silico reproduction of JO2 (nmol/mg/min)

% Panel A: P/M - JO2
figure
hold on
box on
% Model respiratory profile 
i=1;
plot(model.g{1,1}{1,1}(:,1),model.g{1,4}{1,1}.CIV/2,'color',colors(i,:),'linewidth',8) % Model parameters are based on nmol/mg/min, so no further conversion is necessary. 
% Data 
yPM_leak1 = [data.PM.JO2_leak1]; % These data were already multiplied by 0.6 to get the correct unit of nmol/mg/min
yPM_leak2 = [data.PM.JO2_leak2];
yPM_oxphos = [data.PM.JO2_oxphos];
% Individual data points
plot(4.75+(0.1-0.2*rand(1,numel(yPM_leak1))),yPM_leak1,'ok','markersize',20,'linewidth',2)
plot(9.75+(0.1-0.2*rand(1,numel(yPM_leak2))),yPM_leak2,'ok','markersize',20,'linewidth',2)
plot(10.5+(0.1-0.2*rand(1,numel(yPM_oxphos))),yPM_oxphos,'ok','markersize',20,'linewidth',2)
% Error bars
errorbar(4.75,mean(yPM_leak1),std(yPM_leak1),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(9.75,mean(yPM_leak2),std(yPM_leak2),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(10.5,mean(yPM_oxphos),std(yPM_oxphos),'.','color',[0 0 0],'markersize',1,'linewidth',2)
% Axes 
set(gcf, 'Position', [1 1 1920 1080]);
ylabel({'J_{O_2}(nmol O_2/mg/min)'},'color',[0 0 0],'fontsize',60);
ylim([0 450])
xlim([0.5 17])
yticks([0 100 200 300 400])
xticks([0 5 10 15])
xticklabels([0 5 10 15])
xlabel({'Time (min)'});
set(gca,'FontName','Georgia','FontSize',40);
set(gcf,'color','none'),set(gca,'color','none')

% Panel B: S/R - JO2
figure
hold on
box on
% Model Respiratory Profile 
i=2;
plot(model.g{1,5}{1,1}(:,1),model.g{1,8}{1,1}.CIV/2,'color',colors(i,:),'linewidth',8)
% Data 
ySR_leak1 = [data.SR.JO2_leak1];
ySR_leak2 = [data.SR.JO2_leak2];
ySR_oxphos = [data.SR.JO2_oxphos];
% Individual data points
plot(2.45+(0.1-0.2*rand(1,numel(ySR_leak1))),ySR_leak1,'ok','markersize',20,'linewidth',2)
plot(4.75+(0.1-0.2*rand(1,numel(ySR_leak2))),ySR_leak2,'ok','markersize',20,'linewidth',2)
plot(5.5+(0.1-0.2*rand(1,numel(ySR_oxphos))),ySR_oxphos,'ok','markersize',20,'linewidth',2)
% Error bars
errorbar(2.45,mean(ySR_leak1),std(ySR_leak1),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(4.75,mean(ySR_leak2),std(ySR_leak2),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(5.5,mean(ySR_oxphos),std(ySR_oxphos),'.','color',[0 0 0],'markersize',1,'linewidth',2)
% Axes 
set(gcf, 'Position', [1 1 1920 1080]); 
ylabel({'J_{O_2}(nmol O_2/mg/min)'},'color',[0 0 0],'fontsize',60);
xlabel({'Time (min)'},'color',[0 0 0],'fontsize',60);
ylim([0 450])
xlim([0.5 8.5])
yticks([0 100 200 300 400])
xticks([0 2 4 6 8 10])
xticklabels([0 2 4 6 8 10]);
set(gca,'FontName','Georgia','FontSize',40);
set(gcf,'color','none'),set(gca,'color','none')

% Panel C: Succinate - JO2
figure
hold on
box on
% Model respiratory profile 
i=3;
plot(model.g{1,9}{1,1}(:,1),model.g{1,12}{1,1}.CIV/2,'color',colors(i,:),'linewidth',8) % Model parameters are based on nmol/mg/min, so no further conversion is necessary. 
% Data 
ySuc_leak1 = [data.S.JO2_leak1]; % These data were already multiplied by 0.6 to get the correct unit of nmol/mg/min
ySuc_leak2 = [data.S.JO2_leak2];
ySuc_oxphos = [data.S.JO2_oxphos];
% Individual data points
plot(2.25+(0.1-0.2*rand(1,numel(ySuc_leak1))),ySuc_leak1,'ok','markersize',20,'linewidth',2)
plot(4.75+(0.1-0.2*rand(1,numel(ySuc_leak2))),ySuc_leak2,'ok','markersize',20,'linewidth',2)
plot(5.5+(0.1-0.2*rand(1,numel(ySuc_oxphos))),ySuc_oxphos,'ok','markersize',20,'linewidth',2)
% Error bars
errorbar(2.25,mean(ySuc_leak1),std(ySuc_leak1),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(4.75,mean(ySuc_leak2),std(ySuc_leak2),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(5.5,mean(ySuc_oxphos),std(ySuc_oxphos),'.','color',[0 0 0],'markersize',1,'linewidth',2)
% Axes 
set(gcf, 'Position', [1 1 1920 1080]); 
ylabel({'J_{O_2}(nmol O_2/mg/min)'},'color',[0 0 0],'fontsize',60);
ylim([0 450])
xlim([0.5 8.5])
yticks([0 100 200 300 400])
xticks([0 2 4 6 8])
xticklabels([0 2 4 6 8])
xlabel({'Time (min)'});
set(gca,'FontName','Georgia','FontSize',40);
set(gcf,'color','none'),set(gca,'color','none')

% In-silico reproduction of JH2O2 (pmol/mg/min)

% Panel D: P/M 
figure
hold on
box on
% Model JH2O2 profile 
i=1;
plot(model.g{1,1}{1,1}(:,1),model.g{1,4}{1,1}.HrP*1e-3/0.1*1e12,'color',colors(i,:),'linewidth',8)
% Data 
yPM_leak1 = [data.PM.JH2O2_leak1];
yPM_leak2 = [data.PM.JH2O2_leak2];
yPM_oxphos = [data.PM.JH2O2_oxphos];
% Individual data points
plot(4.75+(0.1-0.2*rand(1,numel(yPM_leak1))),yPM_leak1,'ok','markersize',20,'linewidth',2)
plot(9.75+(0.1-0.2*rand(1,numel(yPM_leak2))),yPM_leak2,'ok','markersize',20,'linewidth',2)
plot(10.5+(0.1-0.2*rand(1,numel(yPM_oxphos))),yPM_oxphos,'ok','markersize',20,'linewidth',2)
% Error bars
errorbar(4.75,mean(yPM_leak1),std(yPM_leak1),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(9.75,mean(yPM_leak2),std(yPM_leak2),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(10.5,mean(yPM_oxphos),std(yPM_oxphos),'.','color',[0 0 0],'markersize',1,'linewidth',2)
% Axes 
set(gcf, 'Position', [1 1 1920 1080]); 
ylabel({'J_{H_2O_2}(pmol/mg/min)'},'color',[0 0 0],'fontsize',60);
xlabel({'Time (min)'},'color',[0 0 0],'fontsize',60);
ylim([0 150])
xlim([0.5 17])
yticks([0 20 40 60 80 100 120 140])
xticks([0 5 10 15])
xticklabels([0 5 10 15])
set(gca,'FontName','Georgia','FontSize',40);
set(gcf,'color','none'),set(gca,'color','none')

% Pabel E: S/R
figure
hold on
box on
% Model JH2O2 profile 
i=2;
plot(model.g{1,5}{1,1}(:,1),model.g{1,8}{1,1}.HrP*1e-3/0.1*1e12,'color',colors(i,:),'linewidth',8)
% Data 
ySR_leak1 = [data.SR.JH2O2_leak1];
ySR_leak2 = [data.SR.JH2O2_leak2];
ySR_oxphos = [data.SR.JH2O2_oxphos];
% Individual data points
plot(2.45+(0.1-0.2*rand(1,numel(ySR_leak1))),ySR_leak1,'ok','markersize',20,'linewidth',2)
plot(4.75+(0.1-0.2*rand(1,numel(ySR_leak2))),ySR_leak2,'ok','markersize',20,'linewidth',2)
plot(5.5+(0.1-0.2*rand(1,numel(ySR_oxphos))),ySR_oxphos,'ok','markersize',20,'linewidth',2)
% Error bars
errorbar(2.45,mean(ySR_leak1),std(ySR_leak1),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(4.75,mean(ySR_leak2),std(ySR_leak2),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(5.5,mean(ySR_oxphos),std(ySR_oxphos),'.','color',[0 0 0],'markersize',1,'linewidth',2)
% Axes 
set(gcf, 'Position', [1 1 1920 1080]); 
ylabel({'J_{H_2O_2}(pmol/mg/min)'},'color',[0 0 0],'fontsize',60);
xlabel({'Time (min)'},'color',[0 0 0],'fontsize',60);
ylim([0 300])
xlim([0.5 8.5])
yticks([0 50 100 150 200 250 300])
xticks([0 2 4 6 8])
xticklabels([0 2 4 6 8])
set(gca,'FontName','Georgia','FontSize',40);
set(gcf,'color','none'),set(gca,'color','none')

% Panel F: Succinate
figure
hold on
box on
% Model JH2O2 profile 
i=3;
plot(model.g{1,9}{1,1}(:,1),model.g{1,12}{1,1}.HrP*1e-3/0.1*1e12,'color',colors(i,:),'linewidth',8)
% Data 
yS_leak1 = [data.S.JH2O2_leak1];
yS_leak2 = [data.S.JH2O2_leak2];
yS_oxphos = [data.S.JH2O2_oxphos];
% Individual data points
plot(2.45+(0.1-0.2*rand(1,numel(yS_leak1))),yS_leak1,'ok','markersize',20,'linewidth',2)
plot(4.75+(0.1-0.2*rand(1,numel(yS_leak2))),yS_leak2,'ok','markersize',20,'linewidth',2)
plot(5.5+(0.1-0.2*rand(1,numel(yS_oxphos))),yS_oxphos,'ok','markersize',20,'linewidth',2)
% Error bars
errorbar(2.45,mean(yS_leak1),std(yS_leak1),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(4.75,mean(yS_leak2),std(yS_leak2),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(5.5,mean(yS_oxphos),std(yS_oxphos),'.','color',[0 0 0],'markersize',1,'linewidth',2)
% Axes 
set(gcf, 'Position', [1 1 1920 1080]); 
ylabel({'J_{H_2O_2}(pmol/mg/min)'},'color',[0 0 0],'fontsize',60);
xlabel({'Time (min)'},'color',[0 0 0],'fontsize',60);
ylim([0 6000])
xlim([0.5 8.5])
yticks([0 1000 2000 3000 4000 5000 6000])
xticks([0 2 4 6 8])
xticklabels([0 2 4 6 8])
set(gca,'FontName','Georgia','FontSize',40,'Color',[0 0 0]);
set(gcf,'color','none'),set(gca,'color','none')

%% FIG 3: NADH Reduction 

% Panel A: P/M   
figure
hold on
box on
% Model NADH dynamics
i=1;
plot(model.g{1,1}{1,1}(:,1),model.g{1,2}{1,1}(:,p.i.NADH_x)./p.Ntot*100,'color',colors(i,:),'linewidth',8)
% Data
N_PMleak = [data.PM.NADH_leak];
N_PMoxphos = [data.PM.NADH_oxphos];
% Individual data points
plot(4.75+(0.1-0.2*rand(1,numel(N_PMleak))),N_PMleak,'ok','markersize',20,'linewidth',2)
plot(10.5+(0.1-0.2*rand(1,numel(N_PMoxphos))),N_PMoxphos,'ok','markersize',20,'linewidth',2)
% Error bars
errorbar(4.75,mean(N_PMleak),std(N_PMleak),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(10.5,mean(N_PMoxphos),std(N_PMoxphos),'.','color',[0 0 0],'markersize',1,'linewidth',2)
% Axes 
set(gcf, 'Position', [1 1 1920 1080]); % Maximize figure.
ylabel({'% NADH Reduction'},'color',[0 0 0],'fontsize',60);
xlabel({'Time (min)'},'color',[0 0 0],'fontsize',60);
ylim([0 125])
xlim([0.5 17])
yticks([0 25 50 75 100 125])
xticks([0 5 10 15 20])
xticklabels([0 5 10 15 20])
set(gca,'FontName','Georgia','FontSize',40);
set(gcf,'color','none'),set(gca,'color','none')

% Panel B: S/R
figure
hold on
box on
% Model NADH dynamics
i=2;
plot(model.g{1,5}{1,1}(:,1),model.g{1,6}{1,1}(:,p.i.NADH_x)./p.Ntot*100,'color',colors(i,:),'linewidth',8)
% Data
N_SRleak = [data.SR.NADH_leak];
N_SRoxphos = [data.SR.NADH_oxphos];
% Individual data points
plot(2.45+(0.1-0.2*rand(1,numel(N_SRleak))),N_SRleak,'ok','markersize',20,'linewidth',2)
plot(5.5+(0.1-0.2*rand(1,numel(N_SRoxphos))),N_SRoxphos,'ok','markersize',20,'linewidth',2)
% Error bars
errorbar(2.45,mean(N_SRleak),std(N_SRleak),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(5.5,mean(N_SRoxphos),std(N_SRoxphos),'.','color',[0 0 0],'markersize',1,'linewidth',2)
% Axes 
set(gcf, 'Position', [1 1 1920 1080]); % Maximize figure.
ylabel({'% NADH Reduction'},'color',[0 0 0],'fontsize',60);
xlabel({'Time (min)'},'color',[0 0 0],'fontsize',60);
ylim([0 125])
xlim([0.5 8.5])
yticks([0 25 50 75 100 125])
xticks([0 2 4 6 8])
xticklabels([0 2 4 6 8]);
set(gca,'FontName','Georgia','FontSize',40);
set(gcf,'color','none'),set(gca,'color','none')

%% MODEL VALIDATION
%% FIG 4: P/M/S JO2, JH2O2 and [O2]

% Panel A: JO2
figure
hold on
box on
% Model respiratory profile 
i=4;
plot(model.g{1,13}{1,1}(:,1),model.g{1,16}{1,1}.CIV/2,'color',colors(i,:),'linewidth',8)
% Data 
yPMS_leak1 = [data.PMS.JO2_leak1];
yPMS_leak2 = [data.PMS.JO2_leak2];
yPMS_oxphos = [data.PMS.JO2_oxphos];
% Individual data points
plot(2+(0.1-0.2*rand(1,numel(yPMS_leak1))),yPMS_leak1,'ok','markersize',20,'linewidth',2)
plot(4+(0.1-0.2*rand(1,numel(yPMS_leak2))),yPMS_leak2,'ok','markersize',20,'linewidth',2)
plot(5+(0.1-0.2*rand(1,numel(yPMS_oxphos))),yPMS_oxphos,'ok','markersize',20,'linewidth',2)
% Error bars
errorbar(2,mean(yPMS_leak1),std(yPMS_leak1),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(4,mean(yPMS_leak2),std(yPMS_leak2),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(5,mean(yPMS_oxphos),std(yPMS_oxphos),'.','color',[0 0 0],'markersize',1,'linewidth',2)
% Axes 
set(gcf, 'Position', [1 1 1920 1080]); % Maximize figure.
% ylabel({'J_{O_2}(nmol O_2/mg/min)'},'color',[0 0 0],'fontsize',60);
xlabel({'Time (min)'},'color',[0 0 0],'fontsize',60);
ylim([0 900])
xlim([0 6.5])
yticks([0 200 400 600 800 1000])
xticks([0 2 4 6])
xticklabels([0 2 4 6]);
set(gca,'FontName','Georgia','FontSize',40);
set(gcf,'color','none'),set(gca,'color','none')

% Panel B: JH2O2
figure
hold on
box on
% Model H2O2 dynamics 
i=4;
plot(model.g{1,13}{1,1}(:,1),model.g{1,16}{1,1}.HrP*1e-3/0.1*1e12,'color',colors(i,:),'linewidth',8)
% Data 
yPMS_leak1 = [data.PMS.JH2O2_leak1];
yPMS_leak2 = [data.PMS.JH2O2_leak2];
yPMS_oxphos = [data.PMS.JH2O2_oxphos];
% Individual data points
plot(2+(0.1-0.2*rand(1,numel(yPMS_leak1))),yPMS_leak1,'ok','markersize',20,'linewidth',2)
plot(4+(0.1-0.2*rand(1,numel(yPMS_leak2))),yPMS_leak2,'ok','markersize',20,'linewidth',2)
plot(5+(0.1-0.2*rand(1,numel(yPMS_oxphos))),yPMS_oxphos,'ok','markersize',20,'linewidth',2)
% Error bars
errorbar(2,mean(yPMS_leak1),std(yPMS_leak1),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(4,mean(yPMS_leak2),std(yPMS_leak2),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(5,mean(yPMS_oxphos),std(yPMS_oxphos),'.','color',[0 0 0],'markersize',1,'linewidth',2)
% Axes 
set(gcf, 'Position', [1 1 1920 1080]); % Maximize figure.
% ylabel({'J_{H_2O_2}(pmol/mg/min)'},'color',[0 0 0],'fontsize',60);
xlabel({'Time (min)'},'color',[0 0 0],'fontsize',60);
ylim([0 5250])
xlim([0.5 6.5])
yticks([0 1000 2000 3000 4000 5000])
xticks([0 2 4 6])
xticklabels([0 2 4 6]);
set(gca,'FontName','Georgia','FontSize',40);
set(gcf,'color','none'),set(gca,'color','none')

% Panel C: [O2]
figure
hold on
box on
% Model [O2] dynamics 
i=4;
plot(model.g{1,13}{1,1}(:,1),model.g{1,14}{1,1}(:,p.i.O2_x).*1e6,'color',colors(i,:),'linewidth',8)
% Data 
yPMS_leak1 = [data.PMS.O2_leak1];
yPMS_leak2 = [data.PMS.O2_leak2];
yPMS_oxphos = [data.PMS.O2_oxphos];
% Individual data points
plot(2+(0.1-0.2*rand(1,numel(yPMS_leak1))),yPMS_leak1,'ok','markersize',20,'linewidth',2)
plot(4+(0.1-0.2*rand(1,numel(yPMS_leak2))),yPMS_leak2,'ok','markersize',20,'linewidth',2)
plot(5+(0.1-0.2*rand(1,numel(yPMS_oxphos))),yPMS_oxphos,'ok','markersize',20,'linewidth',2)
% Error bars
errorbar(2,mean(yPMS_leak1),std(yPMS_leak1),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(4,mean(yPMS_leak2),std(yPMS_leak2),'.','color',[0 0 0],'markersize',1,'linewidth',2)
errorbar(5,mean(yPMS_oxphos),std(yPMS_oxphos),'.','color',[0 0 0],'markersize',1,'linewidth',2)
% Axes 
set(gcf, 'Position', [1 1 1920 1080]); % Maximize figure.
% ylabel({'[O_2](\muM)'},'color',[0 0 0],'fontsize',60);
xlabel({'Time (min)'},'color',[0 0 0],'fontsize',60);
ylim([0 200])
xlim([0.5 6.5])
yticks([0 50 100 150 200])
xticks([0 2 4 6])
xticklabels([0 2 4 6]);
set(gca,'FontName','Georgia','FontSize',40);
set(gcf,'color','none'),set(gca,'color','none')

%% FIG 5: JH2O2 v.s. [O2]
id = [find(strcmp(data.label,'PM_O2vJH2O2set1a.txt')) ...
    find(strcmp(data.label,'SR_combinedO2vJH2O2set1a.txt'))];

im = [find(strcmp(model.label,'PM_O2vJH2O2set1a.txt')) ...
    find(strcmp(model.label,'SR_combinedO2vJH2O2set1a.txt'))];

% Panel A: P/M
figure
hold on
box on
i=1;
plot(model.Y{1,im(i)}(:,1),model.Y{1,im(i)}(:,2),'color',colors(1,:),'linewidth',4) % converted to the correct unit in the fitting f(x)
errorbar(data.Y{1,id(i)}(:,1),data.Y{1,id(i)}(:,2),data.Y{1,id(i)}(:,3),'o','MarkerSize',18,'color',[0 0 0],'linewidth',2)
set(gcf, 'Position', get(0,'Screensize')); % Maximize figure.
ylabel({'J_{H_2O_2}(pmol/mg/min)'},'color',[0 0 0],'fontsize',60);
xlabel({'[O_2] (\muM)'},'color',[0 0 0],'fontsize',60);
xlim([0 200])
ylim([0 150])
set(gca,'FontSize',54,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')

% Panel B: S/R
figure
hold on
box on
i=2;
plot(model.Y{1,im(i)}(:,1),model.Y{1,im(i)}(:,2),'color',colors(2,:),'linewidth',4) % converted to the correct unit in the fitting f(x)
errorbar(data.Y{1,id(i)}(:,1),data.Y{1,id(i)}(:,2),data.Y{1,id(i)}(:,3),'o','MarkerSize',18,'color',[0 0 0],'linewidth',2)
set(gcf, 'Position', get(0,'Screensize')); % Maximize figure.
ylabel({'J_{H_2O_2}(pmol/mg/min)'},'color',[0 0 0],'fontsize',60);
xlabel({'[O_2] (\muM)'},'color',[0 0 0],'fontsize',60);
xlim([0 200])
ylim([0 300])
set(gca,'FontSize',54,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')

%% MODEL PREDICTION
%% FIG 7. Model analysis to explain the monotonicity of JH2O2 on [O2]

% P/M
% Total ROS & Scavenging activity
figure 
hold on
box on
yyaxis left
% Total ROS 
plot(model.g{1,18}(:,p.i.O2_x).*1e6,model.g{1,20}.CI.JSO/2 + model.g{1,20}.CI.JH2O2 + model.g{1,20}.CII.JSO/2 + model.g{1,20}.CII.JH2O2 + model.g{1,20}.CIII.JSO/2,'color',[0 0.447 0.741],'linewidth',6)
% SO
plot(model.g{1,18}(:,p.i.O2_x).*1e6,model.g{1,20}.CI.JSO + model.g{1,20}.CII.JSO + model.g{1,20}.CIII.JSO,'--','color',[0 0.447 0.741],'linewidth',6)
% H2O2 
plot(model.g{1,18}(:,p.i.O2_x).*1e6,model.g{1,20}.CI.JH2O2 + model.g{1,20}.CII.JH2O2,':','color',[0 0.447 0.741],'linewidth',6)
set(gcf, 'Position', [1 1 1920 1080]); % Maximize figure.
ylabel({'J_{ROS}(M/min)'},'color',[0 0 0],'fontsize',60);
xlabel({'[O_2] (\muM)'},'color',[0 0 0],'fontsize',60);
ylim([0 1.5])
xlim([0 210])
yticks([0 0.5 1.0 1.5])
ytickformat('%,.1f')
xticks([0 25 50 75 100 125 150 175 200])
xticklabels([0 25 50 75 100 125 150 175 200])
set(gca,'FontSize',45,'FontName','Times New Roman')
% Scavenging
yyaxis right
plot(model.g{1,18}(:,p.i.O2_x).*1e6,model.g{1,20}.H2O2scavenge/p.kf_scavenging,'color',[0 0 0],'linewidth',6)
ylabel({'Active Scavenging'},'color',[0 0 0],'fontsize',60);
ylim([0 0.015])
ytickformat('%,.3f')
set(gcf,'color','none'),set(gca,'color','none')

% Hydrogen peroxide by IF and IIF
figure 
hold on
box on
plot(model.g{1,18}(:,p.i.O2_x).*1e6,model.g{1,20}.CI.d.JFrH2O2,':','color',[0 0.447 0.741],'linewidth',6)
plot(model.g{1,18}(:,p.i.O2_x).*1e6,model.g{1,20}.CII.d.JFADH2_H2O2,'--','color',[0 0.447 0.741],'linewidth',6)
% plot(model.g{1,18}(:,p.i.O2_x).*1e6,model.g{1,20}.CI.JH2O2 + model.g{1,20}.CII.JH2O2,'color',[0 0 0],'linewidth',3)
set(gcf, 'Position', [1 1 1920 1080]); % Maximize figure.
ylabel({'J_{H2O2}(M/min)'},'color',[0 0 0],'fontsize',45);
xlabel({'[O_2] (\muM)'},'color',[0 0 0],'fontsize',45);
ylim([0 0.03])
xlim([0 210])
yticks([0 0.010 0.020 0.030])
ytickformat('%,.2f')
xticks([0 25 50 75 100 125 150 175 200])
xticklabels([0 25 50 75 100 125 150 175 200])
set(gca,'FontSize',45,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')

% NADH & Q pool redox state
% NADH
figure
hold on
box on
yyaxis left
plot(model.g{1,18}(:,p.i.O2_x).*1e6,model.g{1,18}(:,p.i.NADH_x)/p.Ntot,'color',[0 0.447 0.741],'linewidth',6)
set(gcf, 'Position', [1 1 1920 1080]); % Maximize figure.
ylabel({'Fractional NADH'},'color',[0 0 0],'fontsize',45);
xlabel({'[O_2] (\muM)'},'color',[0 0 0],'fontsize',45);
ylim([0 1])
xlim([0 210])
yticks([0 0.2 0.4 0.6 0.8 1.0])
ytickformat('%,.1f')
xticks([0 25 50 75 100 125 150 175 200])
xticklabels([0 25 50 75 100 125 150 175 200])
set(gca,'FontSize',45,'FontName','Times New Roman')
% Quinol
yyaxis right
plot(model.g{1,18}(:,p.i.O2_x).*1e6,model.g{1,18}(:,p.i.UQH2_x)/p.Qtot,'--','color',[0 0.447 0.741],'linewidth',6)
ylabel({'Fractional QH_2'},'color',[0 0 0],'fontsize',45);
ylim([0 1])
yticks([0 0.2 0.4 0.6 0.8 1.0])
ytickformat('%,.1f')
set(gca,'FontSize',45,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')

% S/R
% Total ROS & Scavenging activity
figure 
hold on
box on
yyaxis left
% Total ROS 
plot(model.g{1,22}(:,p.i.O2_x).*1e6,model.g{1,24}.CI.JSO/2 + model.g{1,24}.CI.JH2O2 + model.g{1,24}.CII.JSO/2 + model.g{1,24}.CII.JH2O2 + model.g{1,24}.CIII.JSO/2,'color',[0.85 0.325 0.098],'linewidth',6)
% SO
plot(model.g{1,22}(:,p.i.O2_x).*1e6,model.g{1,24}.CI.JSO + model.g{1,24}.CII.JSO + model.g{1,24}.CIII.JSO,'--','color',[0.85 0.325 0.098],'linewidth',6)
% H2O2 
plot(model.g{1,22}(:,p.i.O2_x).*1e6,model.g{1,24}.CI.JH2O2 + model.g{1,24}.CII.JH2O2,':','color',[0.85 0.325 0.098],'linewidth',6)
set(gcf, 'Position', [1 1 1920 1080]); % Maximize figure.
ylabel({'J_{ROS}(M/min)'},'color',[0 0 0],'fontsize',60);
xlabel({'[O_2] (\muM)'},'color',[0 0 0],'fontsize',60);
ylim([0 3.0])
xlim([0 210])
yticks([0 0.5 1.0 1.5 2.0 2.5 3.0])
ytickformat('%,.1f')
xticks([0 25 50 75 100 125 150 175 200])
xticklabels([0 25 50 75 100 125 150 175 200])
set(gca,'FontSize',45,'FontName','Times New Roman')
% Scavenging
yyaxis right
plot(model.g{1,22}(:,p.i.O2_x).*1e6,model.g{1,24}.H2O2scavenge/p.kf_scavenging,'color',[0 0 0],'linewidth',6)
ylabel({'Active Scavenging'},'color',[0 0 0],'fontsize',60);
ylim([0 0.08])
ytickformat('%,.2f')
set(gcf,'color','none'),set(gca,'color','none')

% Hydrogen peroxide by IF and IIF
figure 
hold on
box on
plot(model.g{1,22}(:,p.i.O2_x).*1e6,model.g{1,24}.CI.d.JFrH2O2,':','color',[0.85 0.325 0.098],'linewidth',6)
plot(model.g{1,22}(:,p.i.O2_x).*1e6,model.g{1,24}.CII.d.JFADH2_H2O2,'--','color',[0.85 0.325 0.098],'linewidth',6)
set(gcf, 'Position', [1 1 1920 1080]); % Maximize figure.
ylabel({'J_{H2O2}(M/min)'},'color',[0 0 0],'fontsize',45);
xlabel({'[O_2] (\muM)'},'color',[0 0 0],'fontsize',45);
ylim([0 2.0])
xlim([0 210])
yticks([0 0.4 0.8 1.2 1.6 2.0])
ytickformat('%,.1f')
xticks([0 25 50 75 100 125 150 175 200])
xticklabels([0 25 50 75 100 125 150 175 200])
set(gca,'FontSize',45,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')

% NADH & Q pool redox state
% NADH
figure
hold on
box on
yyaxis left
plot(model.g{1,22}(:,p.i.O2_x).*1e6,model.g{1,22}(:,p.i.NADH_x)/p.Ntot,'color',[0.85 0.325 0.098],'linewidth',6)
set(gcf, 'Position', [1 1 1920 1080]); % Maximize figure.
ylabel({'Fractional NADH'},'color',[0 0 0],'fontsize',45);
xlabel({'[O_2] (\muM)'},'color',[0 0 0],'fontsize',45);
ylim([0 1])
xlim([0 210])
yticks([0 0.2 0.4 0.6 0.8 1.0])
ytickformat('%,.1f')
xticks([0 25 50 75 100 125 150 175 200])
xticklabels([0 25 50 75 100 125 150 175 200])
set(gca,'FontSize',45,'FontName','Times New Roman')
% Quinol
yyaxis right
plot(model.g{1,22}(:,p.i.O2_x).*1e6,model.g{1,22}(:,p.i.UQH2_x)/p.Qtot,'--','color',[0.85 0.325 0.098],'linewidth',6)
ylabel({'Fractional QH_2'},'color',[0 0 0],'fontsize',45);
ylim([0 1])
xlim([0 210])
yticks([0 0.2 0.4 0.6 0.8 1.0])
ytickformat('%,.1f')
set(gca,'FontSize',45,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')

%% FIG 8: Site-specific SO production 
im = [find(strcmp(model.label,'PM_JH2O2set1a.txt')) ...
    find(strcmp(model.label,'SR_JH2O2set1a.txt'))...
    find(strcmp(model.label,'Suc_JH2O2set1a.txt'))];

% Panel A: LEAK

% Time intervals
ileak_PM = (model.g{1,1}{1,1}(:,1) >= 4 & model.g{1,1}{1,1}(:,1) < 5)';  
ileak_SR = (model.g{1,5}{1,1}(:,1) >= 2.5 & model.g{1,5}{1,1}(:,1) < 3)';
ileak_S = (model.g{1,9}{1,1}(:,1) >= 2.5 & model.g{1,9}{1,1}(:,1) < 3)';
ileak_PMS = (model.g{1,13}{1,1}(:,1) >= 2 & model.g{1,13}{1,1}(:,1) < 2.5)';

% P/M
CIa_SQSO = mean(model.g{1,4}{1,1}.CI.d.JSQSO(:,ileak_PM)); % SO from the semiquinone
CIa_FrSO = mean(model.g{1,4}{1,1}.CI.d.JFrSO(:,ileak_PM)); % SO from the fully reduced FMN
CIa_FradSO = mean(model.g{1,4}{1,1}.CI.d.JFradSO(:,ileak_PM)); % SO from the FMN radical
CIIa_SQSO = mean(model.g{1,4}{1,1}.CII.d.JSQ_SO(:,ileak_PM)); % SO from the semiquinone
CIIa_ISC3SO = mean(model.g{1,4}{1,1}.CII.d.JISC3_SO(:,ileak_PM)); % SO from the [3Fe-4S] cluster
CIIa_FradSO = mean(model.g{1,4}{1,1}.CII.d.JFADH_SO(:,ileak_PM)); % SO from the FMN radical
CIIa_FrSO = mean(model.g{1,4}{1,1}.CII.d.JFADH2_SO(:,ileak_PM)); % SO from the fully reduced FMN 
CIIIa_QpSO = mean(model.g{1,4}{1,1}.CIII.d.JSO(:,ileak_PM));

% S/R
CIb_SQSO = mean(model.g{1,8}{1,1}.CI.d.JSQSO(:,ileak_SR)); % SO from the semiquinone
CIb_FrSO = mean(model.g{1,8}{1,1}.CI.d.JFrSO(:,ileak_SR)); % SO from the fully reduced FMN
CIb_FradSO = mean(model.g{1,8}{1,1}.CI.d.JFradSO(:,ileak_SR)); % SO from the FMN radical
CIIb_SQSO = mean(model.g{1,8}{1,1}.CII.d.JSQ_SO(:,ileak_SR)); % SO from the semiquinone
CIIb_ISC3SO = mean(model.g{1,8}{1,1}.CII.d.JISC3_SO(:,ileak_SR)); % SO from the [3Fe-4S] cluster
CIIb_FradSO = mean(model.g{1,8}{1,1}.CII.d.JFADH_SO(:,ileak_SR)); % SO from the FMN radical
CIIb_FrSO = mean(model.g{1,8}{1,1}.CII.d.JFADH2_SO(:,ileak_SR)); % SO from the fully reduced FMN 
CIIIb_QpSO = mean(model.g{1,8}{1,1}.CIII.d.JSO(:,ileak_SR));

% S
CIc_SQSO = mean(model.g{1,12}{1,1}.CI.d.JSQSO(:,ileak_S)); % SO from the semiquinone
CIc_FrSO = mean(model.g{1,12}{1,1}.CI.d.JFrSO(:,ileak_S)); % SO from the fully reduced FMN
CIc_FradSO = mean(model.g{1,12}{1,1}.CI.d.JFradSO(:,ileak_S)); % SO from the FMN radical
CIIc_SQSO = mean(model.g{1,12}{1,1}.CII.d.JSQ_SO(:,ileak_S)); % SO from the semiquinone
CIIc_ISC3SO = mean(model.g{1,12}{1,1}.CII.d.JISC3_SO(:,ileak_S)); % SO from the [3Fe-4S] cluster
CIIc_FradSO = mean(model.g{1,12}{1,1}.CII.d.JFADH_SO(:,ileak_S)); % SO from the FMN radical
CIIc_FrSO = mean(model.g{1,12}{1,1}.CII.d.JFADH2_SO(:,ileak_S)); % SO from the fully reduced FMN 
CIIIc_QpSO = mean(model.g{1,12}{1,1}.CIII.d.JSO(:,ileak_S));

% P/M/S
CId_SQSO = mean(model.g{1,16}{1,1}.CI.d.JSQSO(:,ileak_PMS)); % SO from the semiquinone
CId_FrSO = mean(model.g{1,16}{1,1}.CI.d.JFrSO(:,ileak_PMS)); % SO from the fully reduced FMN
CId_FradSO = mean(model.g{1,16}{1,1}.CI.d.JFradSO(:,ileak_PMS)); % SO from the FMN radical
CIId_SQSO = mean(model.g{1,16}{1,1}.CII.d.JSQ_SO(:,ileak_PMS)); % SO from the semiquinone
CIId_ISC3SO = mean(model.g{1,16}{1,1}.CII.d.JISC3_SO(:,ileak_PMS)); % SO from the [3Fe-4S] cluster
CIId_FradSO = mean(model.g{1,16}{1,1}.CII.d.JFADH_SO(:,ileak_PMS)); % SO from the FMN radical
CIId_FrSO = mean(model.g{1,16}{1,1}.CII.d.JFADH2_SO(:,ileak_PMS)); % SO from the fully reduced FMN 
CIIId_QpSO = mean(model.g{1,16}{1,1}.CIII.d.JSO(:,ileak_PMS));

% Plot
figure
hold on
box on
%P/M
i=1;
bar(1,CIa_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(5.5,CIa_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(10,CIa_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(14.5,CIIa_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(19,CIIa_ISC3SO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(23.5,CIIa_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(27.5,CIIa_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(32,CIIIa_QpSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
%S/R
i=2;
bar(2,CIb_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(6.5,CIb_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(11,CIb_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(15.5,CIIb_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(20,CIIb_ISC3SO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(24.5,CIIb_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(28.5,CIIb_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(33,CIIIb_QpSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
%S
i=3;
bar(3,CIc_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(7.5,CIc_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(12,CIc_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(16.5,CIIc_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(21,CIIc_ISC3SO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(25.5,CIIc_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(29.5,CIIc_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(34,CIIIc_QpSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
% P/M/S
i=4;
bar(4,CId_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(8.5,CId_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(13,CId_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(17.5,CIId_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(22,CIId_ISC3SO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(26.5,CIId_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(30.5,CIId_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(35,CIIId_QpSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))

% Axes
set(gcf, 'Position', get(0,'Screensize'));
% ylabel({'J_{SO}(nmol/mg/min)'},'color',[0 0 0],'fontsize',60);
xticks([2.5 7 11.5 16 20.5 25 30 34.5])
yticks([0 5 10 15])
xticklabels({'I_Q','FMNH_2','FMNH^{.-}','II_Q','[3Fe-4S]','FADH^{.-}','FADH_2','Q_p'})
ytickformat('%,.0f')
xlim([0 35.5])
ylim([0 17])
set(gca,'FontSize',38,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')

% FIGURE 8A - inset 
% Plot
figure
hold on
box on
%P/M
i=1;
bar(1,CIa_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(5.5,CIIa_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(10,CIIa_ISC3SO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(14.5,CIIa_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(19,CIIa_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(23.5,CIIIa_QpSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
%S/R
i=2;
bar(2,CIb_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(6.5,CIIb_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(11,CIIb_ISC3SO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(15.5,CIIb_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(20,CIIb_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(24.5,CIIIb_QpSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
%S
i=3;
bar(3,CIc_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(7.5,CIIc_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(12,CIIc_ISC3SO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(16.5,CIIc_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(21,CIIc_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(25.5,CIIIc_QpSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
% P/M/S
i=4;
bar(4,CId_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(8.5,CIId_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(13,CIId_ISC3SO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(17.5,CIId_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(22,CIId_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(26.5,CIIId_QpSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))

% Axes
set(gcf, 'Position', get(0,'Screensize')); % Maximize figure.
% ylabel({'J_{SO}(nmol/mg/min)'},'color',[0 0 0],'fontsize',60);
xticks([2.5 7 11.5 16 20.5 25])
xticklabels({'FMNH^{.-}','II_Q','[3Fe-4S]','FADH^{.-}','FADH_2','Q_p'})
ytickformat('%,.1f')
xlim([0 27])
ylim([0 0.65])
set(gca,'FontSize',38,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')


% Panel B: OXPHOS
% Time intervals
ioxphos_PM = (model.g{1,1}{1,1}(:,1) >= 10 & model.g{1,1}{1,1}(:,1) < 10.5)';  
ioxphos_SR = (model.g{1,5}{1,1}(:,1) >= 5 & model.g{1,5}{1,1}(:,1) < 5.5)';
ioxphos_S = (model.g{1,9}{1,1}(:,1) >= 5 & model.g{1,9}{1,1}(:,1) < 5.5)';
ioxphos_PMS = (model.g{1,13}{1,1}(:,1) >= 4 & model.g{1,13}{1,1}(:,1) < 4.5)';

% P/M
CIa_SQSO = mean(model.g{1,4}{1,1}.CI.d.JSQSO(:,ioxphos_PM)); % SO from the semiquinone
CIa_FrSO = mean(model.g{1,4}{1,1}.CI.d.JFrSO(:,ioxphos_PM)); % SO from the fully reduced FMN
CIa_FradSO = mean(model.g{1,4}{1,1}.CI.d.JFradSO(:,ioxphos_PM)); % SO from the FMN radical
CIIa_SQSO = mean(model.g{1,4}{1,1}.CII.d.JSQ_SO(:,ioxphos_PM)); % SO from the semiquinone
CIIa_ISC3SO = mean(model.g{1,4}{1,1}.CII.d.JISC3_SO(:,ioxphos_PM)); % SO from the [3Fe-4S] cluster
CIIa_FradSO = mean(model.g{1,4}{1,1}.CII.d.JFADH_SO(:,ioxphos_PM)); % SO from the FMN radical
CIIa_FrSO = mean(model.g{1,4}{1,1}.CII.d.JFADH2_SO(:,ioxphos_PM)); % SO from the fully reduced FMN 
CIIIa_QpSO = mean(model.g{1,4}{1,1}.CIII.d.JSO(:,ioxphos_PM));

% S/R
CIb_SQSO = mean(model.g{1,8}{1,1}.CI.d.JSQSO(:,ioxphos_SR)); % SO from the semiquinone
CIb_FrSO = mean(model.g{1,8}{1,1}.CI.d.JFrSO(:,ioxphos_SR)); % SO from the fully reduced FMN
CIb_FradSO = mean(model.g{1,8}{1,1}.CI.d.JFradSO(:,ioxphos_SR)); % SO from the FMN radical
CIIb_SQSO = mean(model.g{1,8}{1,1}.CII.d.JSQ_SO(:,ioxphos_SR)); % SO from the semiquinone
CIIb_ISC3SO = mean(model.g{1,8}{1,1}.CII.d.JISC3_SO(:,ioxphos_SR)); % SO from the [3Fe-4S] cluster
CIIb_FradSO = mean(model.g{1,8}{1,1}.CII.d.JFADH_SO(:,ioxphos_SR)); % SO from the FMN radical
CIIb_FrSO = mean(model.g{1,8}{1,1}.CII.d.JFADH2_SO(:,ioxphos_SR)); % SO from the fully reduced FMN 
CIIIb_QpSO = mean(model.g{1,8}{1,1}.CIII.d.JSO(:,ioxphos_SR));

% S
CIc_SQSO = mean(model.g{1,12}{1,1}.CI.d.JSQSO(:,ioxphos_S)); % SO from the semiquinone
CIc_FrSO = mean(model.g{1,12}{1,1}.CI.d.JFrSO(:,ioxphos_S)); % SO from the fully reduced FMN
CIc_FradSO = mean(model.g{1,12}{1,1}.CI.d.JFradSO(:,ioxphos_S)); % SO from the FMN radical
CIIc_SQSO = mean(model.g{1,12}{1,1}.CII.d.JSQ_SO(:,ioxphos_S)); % SO from the semiquinone
CIIc_ISC3SO = mean(model.g{1,12}{1,1}.CII.d.JISC3_SO(:,ioxphos_S)); % SO from the [3Fe-4S] cluster
CIIc_FradSO = mean(model.g{1,12}{1,1}.CII.d.JFADH_SO(:,ioxphos_S)); % SO from the FMN radical
CIIc_FrSO = mean(model.g{1,12}{1,1}.CII.d.JFADH2_SO(:,ioxphos_S)); % SO from the fully reduced FMN 
CIIIc_QpSO = mean(model.g{1,12}{1,1}.CIII.d.JSO(:,ioxphos_S));

% P/M/S
CId_SQSO = mean(model.g{1,16}{1,1}.CI.d.JSQSO(:,ioxphos_PMS)); % SO from the semiquinone
CId_FrSO = mean(model.g{1,16}{1,1}.CI.d.JFrSO(:,ioxphos_PMS)); % SO from the fully reduced FMN
CId_FradSO = mean(model.g{1,16}{1,1}.CI.d.JFradSO(:,ioxphos_PMS)); % SO from the FMN radical
CIId_SQSO = mean(model.g{1,16}{1,1}.CII.d.JSQ_SO(:,ioxphos_PMS)); % SO from the semiquinone
CIId_ISC3SO = mean(model.g{1,16}{1,1}.CII.d.JISC3_SO(:,ioxphos_PMS)); % SO from the [3Fe-4S] cluster
CIId_FradSO = mean(model.g{1,16}{1,1}.CII.d.JFADH_SO(:,ioxphos_PMS)); % SO from the FMN radical
CIId_FrSO = mean(model.g{1,16}{1,1}.CII.d.JFADH2_SO(:,ioxphos_PMS)); % SO from the fully reduced FMN 
CIIId_QpSO = mean(model.g{1,16}{1,1}.CIII.d.JSO(:,ioxphos_PMS));

% Plot
figure
hold on
box on
%P/M
i=1;
bar(1,CIa_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(5.5,CIa_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(10,CIa_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(14.5,CIIa_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(19,CIIa_ISC3SO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(23.5,CIIa_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(27.5,CIIa_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(32,CIIIa_QpSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
%S/R
i=2;
bar(2,CIb_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(6.5,CIb_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(11,CIb_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(15.5,CIIb_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(20,CIIb_ISC3SO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(24.5,CIIb_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(28.5,CIIb_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(33,CIIIb_QpSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
%S
i=3;
bar(3,CIc_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(7.5,CIc_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(12,CIc_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(16.5,CIIc_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(21,CIIc_ISC3SO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(25.5,CIIc_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(29.5,CIIc_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(34,CIIIc_QpSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
% P/M/S
i=4;
bar(4,CId_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(8.5,CId_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(13,CId_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(17.5,CIId_SQSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(22,CIId_ISC3SO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(26.5,CIId_FradSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(30.5,CIId_FrSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))
bar(35,CIIId_QpSO,'FaceColor',colors(i,:),'EdgeColor',colors(i,:))

% Axes
set(gcf, 'Position', get(0,'Screensize')); 
% ylabel({'J_{SO}(nmol/mg/min)'},'color',[0 0 0],'fontsize',60);
xticks([2.5 7 11.5 16 20.5 25 30 34.5])
xticklabels({'I_Q','FMNH_2','FMNH^{.-}','II_Q','[3Fe-4S]','FADH^{.-}','FADH_2','Q_p'})
ytickformat('%,.1f')
xlim([0 35.5])
ylim([0 2.5])
set(gca,'FontSize',38,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')

%% FIG 9: Site-specific H2O2

% Panel A: LEAK
% FMNH2
CIa_FrH2O2 = mean(model.g{1,4}{1,1}.CI.d.JFrH2O2(:,ileak_PM)); % SO from the FMN radical
CIb_FrH2O2 = mean(model.g{1,8}{1,1}.CI.d.JFrH2O2(:,ileak_SR)); % SO from the FMN radical
CIc_FrH2O2 = mean(model.g{1,12}{1,1}.CI.d.JFrH2O2(:,ileak_S)); % SO from the FMN radical
CId_FrH2O2 = mean(model.g{1,16}{1,1}.CI.d.JFrH2O2(:,ileak_PMS)); % SO from the FMN radical

% FADH2
CIIa_FrH2O2 = mean(model.g{1,4}{1,1}.CII.d.JFADH2_H2O2(:,ileak_PM)); % SO from the fully reduced FMN, INSIGNIFICANT
CIIb_FrH2O2 = mean(model.g{1,8}{1,1}.CII.d.JFADH2_H2O2(:,ileak_SR)); % SO from the fully reduced FMN 
CIIc_FrH2O2 = mean(model.g{1,12}{1,1}.CII.d.JFADH2_H2O2(:,ileak_S)); % SO from the fully reduced FMN 
CIId_FrH2O2 = mean(model.g{1,16}{1,1}.CII.d.JFADH2_H2O2(:,ileak_PMS)); % SO from the fully reduced FMN 

% Plot
figure
hold on
box on
% FMNH2
yyaxis left 
i=1;bar(1,CIa_FrH2O2,'FaceColor',colors(i,:),'EdgeColor',colors(i,:)) % P/M
i=2;bar(2,CIb_FrH2O2,'FaceColor',colors(i,:),'EdgeColor',colors(i,:)) % S/R
i=3;bar(3,CIc_FrH2O2,'FaceColor',colors(i,:),'EdgeColor',colors(i,:)) % S
i=4;bar(4,CId_FrH2O2,'FaceColor',colors(i,:),'EdgeColor',colors(i,:)) % P/M/S
% Axes
set(gcf, 'Position', get(0,'Screensize')); % Maximize figure.
% ylabel({'J_{H2O2}(nmol/mg/min)'},'color',[0 0 0],'fontsize',60);
xticks([2.5 7])
ylim([0 16.5])
xticklabels({'FMNH_2','FADH_2'})
ytickformat('%,.0f')
% FADH2
yyaxis right 
i=1;bar(5.5,CIIa_FrH2O2,'FaceColor',colors(i,:),'EdgeColor',colors(i,:)) % P/M
i=2;bar(6.5,CIIb_FrH2O2,'FaceColor',colors(i,:),'EdgeColor',colors(i,:)) % S/R
i=3;bar(7.5,CIIc_FrH2O2,'FaceColor',colors(i,:),'EdgeColor',colors(i,:)) % S
i=4;bar(8.5,CIId_FrH2O2,'FaceColor',colors(i,:),'EdgeColor',colors(i,:)) % P/M/S
ytickformat('%,.1f')
% Axes
xlim([0 9])
ylim([0 inf])
ylim([0 1.1e-3])
set(gca,'FontSize',50,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')

% Panel B: OXPHOS
% FMNH2
CIa_FrH2O2 = mean(model.g{1,4}{1,1}.CI.d.JFrH2O2(1,ioxphos_PM)); 
CIb_FrH2O2 = mean(model.g{1,8}{1,1}.CI.d.JFrH2O2(1,ioxphos_SR));
CIc_FrH2O2 = mean(model.g{1,12}{1,1}.CI.d.JFrH2O2(1,ioxphos_S)); 
CId_FrH2O2 = mean(model.g{1,16}{1,1}.CI.d.JFrH2O2(1,ioxphos_PMS)); 
% FADH2
CIIa_FrH2O2 = mean(model.g{1,4}{1,1}.CII.d.JFADH2_H2O2(1,ioxphos_PM)); 
CIIb_FrH2O2 = mean(model.g{1,8}{1,1}.CII.d.JFADH2_H2O2(1,ioxphos_SR)); 
CIIc_FrH2O2 = mean(model.g{1,12}{1,1}.CII.d.JFADH2_H2O2(1,ioxphos_S)); 
CIId_FrH2O2 = mean(model.g{1,16}{1,1}.CII.d.JFADH2_H2O2(1,ioxphos_PMS)); 

% Plot
figure
hold on
box on
% FMNH2
yyaxis left 
i=1;bar(1,CIa_FrH2O2,'FaceColor',colors(i,:),'EdgeColor',colors(i,:)) % P/M
i=2;bar(2,CIb_FrH2O2,'FaceColor',colors(i,:),'EdgeColor',colors(i,:)) % S/R
i=3;bar(3,CIc_FrH2O2,'FaceColor',colors(i,:),'EdgeColor',colors(i,:)) % S
i=4;bar(4,CId_FrH2O2,'FaceColor',colors(i,:),'EdgeColor',colors(i,:)) % P/M/S
% Axes
set(gcf, 'Position', get(0,'Screensize')); 
% ylabel({'J_{H2O2}(nmol/mg/min)'},'color',[0 0 0],'fontsize',60);
xticks([2.5 7])
ylim([0 2.5])
xticklabels({'FMNH_2','FADH_2'})
ytickformat('%,.1f')
% FADH2
yyaxis right 
i=1;bar(5.5,CIIa_FrH2O2,'FaceColor',colors(i,:),'EdgeColor',colors(i,:)) % P/M
i=2;bar(6.5,CIIb_FrH2O2,'FaceColor',colors(i,:),'EdgeColor',colors(i,:)) % S/R
i=3;bar(7.5,CIIc_FrH2O2,'FaceColor',colors(i,:),'EdgeColor',colors(i,:)) % S
i=4;bar(8.5,CIId_FrH2O2,'FaceColor',colors(i,:),'EdgeColor',colors(i,:)) % P/M/S
ytickformat('%,.1f')
% Axes
xlim([0 9])
ylim([0 inf])
ylim([0 4.5e-4])
set(gca,'FontSize',50,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')

%% FIG 10: JSO and JH2O2 as a f(x) of NADH/NAD+ and QH2/Q 
% Extracting steady-state variables at 5 minutes and 
% varying NADH and QH2 to assess the effects of these variables on SO and H2O2 

% Picking the first SV set at t >/= 5 min
i = find(model.g{1,1}{1,1}(:,1)>=5,1); 
x0 = model.g{1,2}{1,1}(i,:)'; % SV structure: rows = time, columns = SVs

% Setting NADH and QH2
NADH           = linspace(0,p.Ntot,101); % M (3mM)
NAD            = p.Ntot-NADH;
x0 = x0*ones(1,numel(NADH));

Q                   = linspace(0,p.Qtot,201); % M (20 mM)
QH2                 = p.Qtot - Q;                    
 
% Set NADH/NAD ratios 
% Each column corresponds to a unique SV vector at 5 minutes that differs
% in the NADH/NAD ratio
x0(p.i.O2_x,:) = 20e-6; % M
x0(p.i.NADH_x,:)= NADH; % M
x0(p.i.NAD_x,:) = NAD; % M

% Correcting parameters for ionic strength
p.T = 310.15; % tempm, at 37oC
p.I = 0.15; % ionic strength, in M
p = dGdHcorr(p); % adjust free energies for ionic strength
p = pKacorr(p); % adjust pKs for ionic strength 
p.rotenone = 0;

% Set QH2/Q ratios 
for i=1:numel(Q)
    x0(p.i.UQH2_x,:) = QH2(i);
    x0(p.i.UQ_x,:) =  Q(i);                             %M
    [f{i},J{i}] = DAEs(0,x0,p);
end

% Plots
% CI SO
JCI_SO = zeros(numel(NADH),numel(Q));
[X,Y] = meshgrid(NADH./NAD,QH2./Q); 
for i=1:numel(Q)
    for j=1:numel(NADH)
        JCI_SO(:,i) = J{1,i}.CI.JSO; 
    end 
end 
mesh(log10(X),log10(Y),JCI_SO')
xlabel('NADH/NAD')
ylabel('QH_2/Q')
zlabel('J_{SO} (pmol/mg/min)')
set(gcf, 'Position', get(0,'Screensize')); 
set(gca,'FontSize',40,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')

% CI H2O2
JCI_H2O2 = zeros(numel(NADH),numel(Q));
[X,Y] = meshgrid(NADH./NAD,QH2./Q); 
for i=1:numel(Q)
    for j=1:numel(NADH)
        JCI_H2O2(:,i) = J{1,i}.CI.JH2O2; 
    end 
end 
mesh(log10(X),log10(Y),JCI_H2O2')
xlabel('NADH/NAD')
ylabel('QH_2/Q')
zlabel('J_{H2O2} (pmol/mg/min)')
set(gcf, 'Position', get(0,'Screensize'));
set(gca,'FontSize',40,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')

% CII SO 
JCII_SO = zeros(numel(NADH),numel(Q));
[X,Y] = meshgrid(NADH./NAD,QH2./Q); 
for i=1:numel(Q)
    for j=1:numel(NADH)
        JCII_SO(:,i) = J{1,i}.CII.JSO; 
    end 
end 
mesh(log10(X),log10(Y),JCII_SO')
xlabel('NADH/NAD')
ylabel('QH_2/Q')
zlabel('J_{SO} (pmol/mg/min)')
ytickformat('%,.0f')
ztickformat('%,.2f')
set(gcf, 'Position', get(0,'Screensize')); 
set(gca,'FontSize',40,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')

% CII H2O2
JCII_H2O2 = zeros(numel(NADH),numel(Q));
[X,Y] = meshgrid(NADH./NAD,QH2./Q); 
for i=1:numel(Q)
    for j=1:numel(NADH)
        JCII_H2O2(:,i) = J{1,i}.CII.JH2O2; 
    end 
end 
mesh(log10(X),log10(Y),JCII_H2O2')
xlabel('NADH/NAD')
ylabel('QH_2/Q')
zlabel('J_{H2O2} (pmol/mg/min)')
set(gcf, 'Position', get(0,'Screensize'));
set(gca,'FontSize',40,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')

% CIII SO
JCIII_SO = zeros(numel(NADH),numel(Q));
[X,Y] = meshgrid(NADH./NAD,QH2./Q);
for i=1:numel(Q)
    %for j=1:numel(NADH)
        JCIII_SO(:,i) = J{1,i}.CIII.JSO; %.*1e-3/0.1*1e12;
    %end 
end 
mesh(log10(X),log10(Y),JCIII_SO')
xlabel('NADH/NAD')
ylabel('QH_2/Q')
zlabel('J_{SO} (pmol/mg/min)')
set(gcf, 'Position', get(0,'Screensize')); 
set(gca,'FontSize',40,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')

%% FIG 11: Active scavenging
% Panel A: P/M
figure 
hold on
box on
plot(model.g{1,1}{1,1}(:,1),model.g{1,4}{1,1}.H2O2scavenge/p.kf_scavenging,'color',[0 0.447 0.741],'linewidth',6)
% Axes 
set(gcf, 'Position', [1 1 1920 1080]); 
ylabel({'Active Scavenging'},'color',[0 0 0],'fontsize',60);
xlabel({'Time (min)'},'color',[0 0 0],'fontsize',60);
ylim([0 0.012])
xlim([0.5 17])
yticks([0 0.002 0.004 0.006 0.008 0.01 0.012])
ytickformat('%,.3f')
xticks([0 2 4 6 8 10 12 14 16])
xticklabels([0 2 4 6 8 10 12 14 16])
set(gca,'FontSize',45,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')

% Panel B: S/R
figure 
hold on
box on
plot(model.g{1,5}{1,1}(:,1),model.g{1,8}{1,1}.H2O2scavenge/p.kf_scavenging,'color',[0.85 0.325 0.098],'linewidth',6)
% Axes 
set(gcf, 'Position', [1 1 1920 1080]);
ylabel({'Active Scavenging'},'color',[0 0 0],'fontsize',60);
xlabel({'Time (min)'},'color',[0 0 0],'fontsize',60);
ylim([0 0.08])
xlim([0.5 8.5])
yticks([0 0.01 0.02 0.03 0.04 0.05 0.06])
ytickformat('%,.2f')
xticks([0 2 4 6 8])
xticklabels([0 2 4 6 8])
set(gca,'FontSize',45,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')

% Panel C: S
figure 
hold on
box on
plot(model.g{1,9}{1,1}(:,1),model.g{1,12}{1,1}.H2O2scavenge/p.kf_scavenging,'color',[0.929 0.694 0.125],'linewidth',6)
% Axes 
set(gcf, 'Position', [1 1 1920 1080]);
ylabel({'Active Scavenging'},'color',[0 0 0],'fontsize',60);
xlabel({'Time (min)'},'color',[0 0 0],'fontsize',60);
ylim([0 0.8])
xlim([0.5 8.5])
yticks([0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8])
ytickformat('%,.1f')
xticks([0 2 4 6 8])
xticklabels([0 2 4 6 8])
set(gca,'FontSize',45,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')

% Panel D: P/M/S
figure 
hold on
box on
plot(model.g{1,13}{1,1}(:,1),model.g{1,16}{1,1}.H2O2scavenge/p.kf_scavenging,'color',[0.494 0.184 0.556],'linewidth',6)
% Axes 
set(gcf, 'Position', [1 1 1920 1080]);
ylabel({'Active Scavenging'},'color',[0 0 0],'fontsize',60);
xlabel({'Time (min)'},'color',[0 0 0],'fontsize',60);
ylim([0 0.8])
xlim([0.5 6.5])
yticks([0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8])
ytickformat('%,.1f')
xticks([0 2 4 6 8])
xticklabels([0 2 4 6 8])
set(gca,'FontSize',45,'FontName','Times New Roman')
set(gcf,'color','none'),set(gca,'color','none')